/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.structure;

import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.util.Vec2i;
import cool.muyucloud.croparia.util.supplier.LazySupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class Char2D
implements Iterable<char[]> {
    public static final Codec<Char2D> CODEC = Codec.STRING.listOf().xmap(Char2D::new, Char2D::layer);
    private final char[][] chars;
    private final transient Map<Character, Integer> counts = new HashMap<Character, Integer>();
    private final transient LazySupplier<Integer> hash;

    public Char2D(List<String> layer) {
        if (layer.isEmpty()) {
            throw new IllegalArgumentException("Empty surface");
        }
        int cols = layer.getFirst().length();
        int rows = layer.size();
        this.chars = new char[rows][cols];
        for (int z = 0; z < rows; ++z) {
            String row = layer.get(z);
            if (row.length() != cols) {
                throw new IllegalArgumentException("Varying length: " + String.valueOf(layer));
            }
            this.chars[z] = row.toCharArray();
            for (char c : this.chars[z]) {
                this.counts.compute(Character.valueOf(c), (character, integer) -> integer == null ? 1 : integer + 1);
            }
        }
        this.hash = LazySupplier.of(() -> Arrays.deepHashCode((Object[])this.chars));
    }

    public Char2D(char[][] chars) {
        if (chars.length == 0) {
            throw new IllegalArgumentException("Empty surface");
        }
        int cols = chars[0].length;
        for (char[] row : chars) {
            if (row.length != cols) {
                throw new IllegalArgumentException("Varying length: " + Arrays.deepToString((Object[])chars));
            }
            for (char c : row) {
                this.counts.compute(Character.valueOf(c), (character, integer) -> integer == null ? 1 : integer + 1);
            }
        }
        this.chars = chars;
        this.hash = LazySupplier.of(() -> Arrays.deepHashCode((Object[])chars));
    }

    public List<String> layer() {
        return Arrays.stream(this.chars).map(String::new).toList();
    }

    public int zSize() {
        return this.chars.length;
    }

    public int xSize() {
        return this.chars.length == 0 ? 0 : this.chars[0].length;
    }

    public Char2D rotate() {
        char[][] rotated = new char[this.xSize()][this.zSize()];
        for (int z = 0; z < this.zSize(); ++z) {
            for (int x = 0; x < this.xSize(); ++x) {
                rotated[x][this.zSize() - z - 1] = this.chars[z][x];
            }
        }
        return new Char2D(rotated);
    }

    public Char2D mirror() {
        char[][] mirrored = new char[this.zSize()][this.xSize()];
        for (int z = 0; z < this.zSize(); ++z) {
            for (int x = 0; x < this.xSize(); ++x) {
                mirrored[z][this.xSize() - x - 1] = this.chars[z][x];
            }
        }
        return new Char2D(mirrored);
    }

    public char get(int x, int z) {
        if (x < 0 || x >= this.xSize() || z < 0 || z >= this.zSize()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + x + ", " + z + " for size " + this.xSize() + "x" + this.zSize());
        }
        return this.chars[z][x];
    }

    public boolean contains(char c) {
        return this.counts.getOrDefault(Character.valueOf(c), 0) > 0;
    }

    public int count(char c) {
        return this.counts.getOrDefault(Character.valueOf(c), 0);
    }

    public Collection<Character> chars() {
        return this.counts.keySet();
    }

    public void forEachChar(BiConsumer<Character, Integer> consumer) {
        this.counts.forEach(consumer);
    }

    public Optional<Vec2i> find(char c) {
        if (this.contains(c)) {
            for (int z = 0; z < this.zSize(); ++z) {
                for (int x = 0; x < this.xSize(); ++x) {
                    if (this.get(x, z) != c) continue;
                    return Optional.of(Vec2i.of(x, z));
                }
            }
        } else {
            return Optional.empty();
        }
        throw new IllegalStateException("Char %s not present but found %d times".formatted(Character.valueOf(c), this.count(c)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Char2D)) {
            return false;
        }
        Char2D that = (Char2D)o;
        return Objects.deepEquals(this.chars, that.chars);
    }

    public int hashCode() {
        return this.hash.get();
    }

    @Override
    @NotNull
    public Iterator<char[]> iterator() {
        return Arrays.stream(this.chars).iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (char[] row : this.chars) {
            builder.append(String.valueOf(row)).append(",\n");
        }
        if (builder.isEmpty()) {
            return "[]";
        }
        return "[" + builder.substring(0, builder.length() - 2) + "]";
    }
}

