/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import cool.muyucloud.croparia.api.recipe.structure.AbstractChar3D;
import cool.muyucloud.croparia.api.recipe.structure.Char2D;
import cool.muyucloud.croparia.util.Vec2i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public class Char3D
extends AbstractChar3D<Char3D>
implements Iterable<Char2D> {
    public static final Codec<Char3D> CODEC = Char2D.CODEC.listOf().xmap(Char3D::new, Char3D::layers);
    private final List<Char2D> pattern;
    private final Map<Character, Integer> counts;
    protected transient int hash = 0;

    public Char3D(Char3D old) {
        this.pattern = old.pattern;
        this.counts = old.counts;
    }

    public Char3D(List<Char2D> structure) {
        int height = structure.size();
        int maxZ = structure.getFirst().zSize();
        int maxX = structure.getFirst().xSize();
        ArrayList<Char2D> pattern = new ArrayList<Char2D>(height);
        HashMap counts = new HashMap();
        for (Char2D layer : structure) {
            if (layer.zSize() != maxZ || layer.xSize() != maxX) {
                throw new IllegalArgumentException("Varying size: " + String.valueOf(structure));
            }
            pattern.add(layer);
            layer.forEachChar((c, count) -> counts.compute(c, (character, integer) -> integer == null ? count : integer + count));
        }
        this.pattern = ImmutableList.copyOf(pattern);
        this.counts = ImmutableMap.copyOf(counts);
        this.hash = this.pattern.hashCode();
    }

    @Override
    public List<Char2D> layers() {
        return ImmutableList.copyOf(this.pattern);
    }

    @Override
    public Char3D rotate() {
        ArrayList<Char2D> rotated = new ArrayList<Char2D>(this.pattern.size());
        for (Char2D surface : this.pattern) {
            rotated.add(surface.rotate());
        }
        return new Char3D(rotated);
    }

    @Override
    public Char3D mirror() {
        ArrayList<Char2D> mirrored = new ArrayList<Char2D>(this.pattern.size());
        for (Char2D surface : this.pattern) {
            mirrored.add(surface.mirror());
        }
        return new Char3D(mirrored);
    }

    @Override
    public int ySize() {
        return this.pattern.size();
    }

    @Override
    public int zSize() {
        return this.pattern.isEmpty() ? 0 : this.pattern.getFirst().zSize();
    }

    @Override
    public int xSize() {
        return this.pattern.isEmpty() ? 0 : this.pattern.getFirst().xSize();
    }

    @Override
    public Vec3i size() {
        return new Vec3i(this.xSize(), this.ySize(), this.zSize());
    }

    @Override
    public char get(int x, int y, int z) {
        return this.pattern.get(y).get(x, z);
    }

    @Override
    public int count(char c) {
        return this.counts.getOrDefault(Character.valueOf(c), 0);
    }

    @Override
    public Collection<Character> chars() {
        return this.counts.keySet();
    }

    @Override
    public void forEachChar(BiConsumer<Character, Integer> consumer) {
        this.counts.forEach(consumer);
    }

    @Override
    @NotNull
    public Optional<Vec3i> find(char c) {
        if (this.contains(c)) {
            for (int y = 0; y < this.ySize(); ++y) {
                Optional<Vec2i> result = this.pattern.get(y).find(c);
                if (!result.isPresent()) continue;
                Vec2i pos = result.get();
                return Optional.of(pos.toVec3i(y));
            }
        } else {
            return Optional.empty();
        }
        throw new IllegalStateException("Char %s not present but found %d times".formatted(Character.valueOf(c), this.count(c)));
    }

    @Override
    public boolean contains(char c) {
        return this.counts.containsKey(Character.valueOf(c)) && this.counts.get(Character.valueOf(c)) > 0;
    }

    @Override
    @NotNull
    public Iterator<Char2D> iterator() {
        return this.pattern.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Char3D)) {
            return false;
        }
        Char3D that = (Char3D)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return this.hash == 0 ? (this.hash = this.pattern.hashCode()) : this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Char2D layer : this.pattern) {
            builder.append(layer).append(",\n");
        }
        if (builder.isEmpty()) {
            return "[]";
        }
        return "[" + builder.substring(0, builder.length() - 2) + "]";
    }
}

