/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.recipe.structure;

import cool.muyucloud.croparia.api.recipe.structure.Char2D;
import cool.muyucloud.croparia.api.recipe.structure.Char3D;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class MarkedChar3D
extends Char3D {
    private final Vec3i mark;

    public MarkedChar3D(Char3D pattern, Vec3i mark) {
        super(pattern);
        if (mark.getX() >= this.xSize() || mark.getY() >= this.ySize() || mark.getZ() >= this.zSize() || mark.getX() < 0 || mark.getY() < 0 || mark.getZ() < 0) {
            throw new IllegalArgumentException("Mark position out of bounds");
        }
        this.mark = mark;
    }

    public MarkedChar3D(List<Char2D> structure, Vec3i mark) {
        super(structure);
        if (mark.getX() >= this.xSize() || mark.getY() >= this.ySize() || mark.getZ() >= this.zSize() || mark.getX() < 0 || mark.getY() < 0 || mark.getZ() < 0) {
            throw new IllegalArgumentException("Mark position out of bounds");
        }
        this.mark = mark;
    }

    public Vec3i mark() {
        return this.mark;
    }

    @Override
    public MarkedChar3D rotate() {
        int newX = this.mark.getZ();
        int newZ = this.zSize() - 1 - this.mark.getX();
        Vec3i rotatedMark = new Vec3i(newX, this.mark.getY(), newZ);
        return new MarkedChar3D(super.rotate(), rotatedMark);
    }

    @Override
    public MarkedChar3D mirror() {
        int newX = this.xSize() - 1 - this.mark.getX();
        int newZ = this.mark.getZ();
        Vec3i mirroredMark = new Vec3i(newX, this.mark.getY(), newZ);
        return new MarkedChar3D(super.mirror(), mirroredMark);
    }

    public BlockPos getOriginInWorld(BlockPos markInWorld) {
        return markInWorld.subtract(this.mark);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MarkedChar3D)) {
            return false;
        }
        MarkedChar3D char3d = (MarkedChar3D)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.mark, char3d.mark);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mark);
    }
}

