/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.resource.TypeToken;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.util.CifUtil;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ContainerRepo(@NotNull Container container) implements Repo<ItemSpec>
{
    @Override
    public int size() {
        return this.container().getContainerSize();
    }

    @Override
    public TypeToken<ItemSpec> getType() {
        return ItemSpec.TYPE;
    }

    @Override
    public boolean isEmpty(int i) {
        return this.container().getItem(i).isEmpty();
    }

    @Override
    public ItemSpec resourceFor(int i) {
        return ItemSpec.of(this.container().getItem(i));
    }

    @Override
    public long simConsume(int i, ItemSpec resource, long amount) {
        ItemStack stack = this.container().getItem(i);
        if (!resource.is(stack)) {
            return 0L;
        }
        long stored = stack.getCount();
        return Math.min(amount, stored);
    }

    @Override
    public long consume(int i, ItemSpec resource, long amount) {
        ItemStack stack = this.container().getItem(i);
        if (!resource.is(stack)) {
            return 0L;
        }
        int stored = stack.getCount();
        int consumed = CifUtil.toIntSafe(Math.min(amount, (long)stored));
        stack.shrink(consumed);
        this.container().setItem(i, stack);
        return consumed;
    }

    @Override
    public long simAccept(int i, ItemSpec resource, long amount) {
        long capacity = this.capacityFor(i, resource);
        long room = capacity - this.amountFor(i);
        amount = Math.min(amount, room);
        if (!this.container().canPlaceItem(i, resource.createStack(amount))) {
            return 0L;
        }
        ItemStack stored = this.container().getItem(i);
        if (resource.is(stored) || stored.isEmpty()) {
            long accepted = Math.min(this.capacityFor(i, resource) - (long)stored.getCount(), amount);
            return Math.max(accepted, 0L);
        }
        return 0L;
    }

    @Override
    public long accept(int i, ItemSpec resource, long amount) {
        long capacity = this.capacityFor(i, resource);
        long room = capacity - this.amountFor(i);
        amount = Math.min(amount, room);
        if (!this.container().canPlaceItem(i, resource.createStack(amount))) {
            return 0L;
        }
        ItemStack stored = this.container().getItem(i);
        if (resource.is(stored) || stored.isEmpty()) {
            long accepted = Math.min(this.capacityFor(i, resource) - (long)stored.getCount(), amount);
            this.container().setItem(i, resource.createStack(Math.max(accepted, 0L) + (long)stored.getCount()));
            return accepted;
        }
        return 0L;
    }

    @Override
    public long capacityFor(int i, ItemSpec resource) {
        ItemStack stored = this.container().getItem(i);
        ItemStack toPlace = resource.createStack();
        int containerSize = this.container().getMaxStackSize(toPlace);
        if (stored.isEmpty() || resource.is(stored)) {
            return containerSize;
        }
        return 0L;
    }

    @Override
    public long amountFor(int i, ItemSpec resource) {
        ItemStack stored = this.container().getItem(i);
        if (resource.is(stored)) {
            return stored.getCount();
        }
        return 0L;
    }

    @Override
    public long amountFor(int i) {
        return this.container().getItem(i).getCount();
    }
}

