/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.api.repo.neoforge;

import cool.muyucloud.croparia.api.repo.Repo;
import cool.muyucloud.croparia.api.repo.RepoProxy;
import cool.muyucloud.croparia.api.resource.type.ItemSpec;
import cool.muyucloud.croparia.util.CifUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemRepoProxy
extends RepoProxy<ItemSpec>
implements IItemHandler {
    public ItemRepoProxy(Repo<ItemSpec> repo) {
        super(repo);
    }

    public int getSlots() {
        return this.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return ((ItemSpec)this.resourceFor(i)).createStack();
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack input, boolean simulate) {
        long accepted = simulate ? this.simAccept(i, ItemSpec.of(input), input.getCount()) : this.accept(i, ItemSpec.of(input), input.getCount());
        input = input.copy();
        input.shrink(CifUtil.toIntSafe(accepted));
        return input;
    }

    @NotNull
    public ItemStack extractItem(int i, int amount, boolean simulate) {
        ItemSpec item = (ItemSpec)this.resourceFor(i);
        ItemStack result = item.createStack();
        long consumed = simulate ? this.simConsume(i, (long)amount) : this.consume(i, (long)amount);
        result.setCount(CifUtil.toIntSafe(consumed));
        return result;
    }

    public int getSlotLimit(int i) {
        return CifUtil.toIntSafe(this.capacityFor(i));
    }

    public boolean isItemValid(int i, @NotNull ItemStack input) {
        return this.simAccept(i, ItemSpec.of(input), input.getCount()) >= (long)input.getCount();
    }
}

