/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.client;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.client.command.ClientCommandRoot;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.DgRegistries;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.Optional;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;

public class CropariaIfClient {
    public static void init() {
        CropariaIf.LOGGER.info("Initializing client setup");
        ClientCommandRoot.register();
        CropariaIf.LOGGER.debug("Registering crop color");
        DgRegistries.CROPS.forLoaded(crop -> {
            ColorHandlerRegistry.registerBlockColors((state, getter, pos, i) -> crop.getColor().getValue(), (Block[])new Block[]{(Block)crop.getCropBlock().orElseThrow()});
            RenderTypeRegistry.register((RenderType)RenderType.cutoutMipped(), (Block[])new Block[]{(Block)crop.getCropBlock().orElseThrow()});
        });
        CropariaIf.LOGGER.debug("Registering cutout rendering");
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)CropariaBlocks.GREENHOUSE.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)CropariaBlocks.ACTIVATED_SHRIEKER.get()});
    }

    public static Optional<LocalPlayer> getLocalPlayer() {
        return Optional.ofNullable(Minecraft.getInstance().player);
    }

    public static Optional<ClientRecipeBook> getClientRecipeBook() {
        return CropariaIfClient.getLocalPlayer().map(LocalPlayer::getRecipeBook);
    }
}

