/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.category;

import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.api.recipe.TypedSerializer;
import cool.muyucloud.croparia.compat.rei.util.ReiDisplay;
import cool.muyucloud.croparia.compat.rei.util.ReiType;
import cool.muyucloud.croparia.util.supplier.Mappable;
import cool.muyucloud.croparia.util.text.Texts;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ReiCategory<R extends DisplayableRecipe<?>>
implements DisplayCategory<ReiDisplay<R>> {
    private final CategoryIdentifier<ReiDisplay<R>> categoryIdentifier;

    public ReiCategory(ReiType<R> proxy) {
        this.categoryIdentifier = proxy.getId();
    }

    public Component getTitle() {
        return Texts.translatable("gui.%s.%s.title".formatted(this.getId().getNamespace(), this.getId().getPath()), new Object[0]);
    }

    public Renderer getIcon() {
        EntryIngredient[] stations = this.stations();
        if (stations.length > 0) {
            return (Renderer)stations[0].getFirst();
        }
        throw new RuntimeException("Override is required if no stations are provided for " + String.valueOf(this.getRecipeType().getId()));
    }

    public abstract TypedSerializer<R> getRecipeType();

    public ResourceLocation getId() {
        return this.getCategoryIdentifier().getIdentifier();
    }

    public EntryIngredient[] stations() {
        EntryIngredient[] array = new EntryIngredient[this.getRecipeType().getStations().size()];
        int i = 0;
        for (Mappable<ItemStack> stack : this.getRecipeType().getStations()) {
            array[i] = EntryIngredients.of((ItemStack)((ItemStack)stack.get()));
            ++i;
        }
        return array;
    }

    public CategoryIdentifier<ReiDisplay<R>> getCategoryIdentifier() {
        return this.categoryIdentifier;
    }
}

