/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cool.muyucloud.croparia.api.recipe.DisplayableRecipe;
import cool.muyucloud.croparia.compat.rei.util.ReiType;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class ReiDisplay<R extends DisplayableRecipe<?>>
implements Display {
    private final R recipe;
    private final ResourceLocation id;
    private final ReiType<R> category;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;

    public static <R extends DisplayableRecipe<?>> DisplaySerializer<ReiDisplay<R>> serializer(ReiType<R> category) {
        return DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)category.getType().codec().fieldOf("recipe").forGetter(ReiDisplay::getRecipe), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(ReiDisplay::getId)).apply((Applicative)instance, (recipe, id) -> new ReiDisplay<DisplayableRecipe>((DisplayableRecipe)recipe, (ResourceLocation)id, category))), (StreamCodec)StreamCodec.of((buf, display) -> {
            category.getType().streamCodec().encode(buf, display.getRecipe());
            buf.writeResourceLocation(display.getId());
        }, buf -> {
            DisplayableRecipe recipe = (DisplayableRecipe)category.getType().streamCodec().decode(buf);
            ResourceLocation id = buf.readResourceLocation();
            return new ReiDisplay<DisplayableRecipe>(recipe, id, category);
        }));
    }

    public ReiDisplay(RecipeHolder<R> holder, ReiType<R> category) {
        this.recipe = (DisplayableRecipe)holder.value();
        this.id = holder.id().location();
        this.category = category;
        this.inputs = this.recipe.getInputs().stream().map(EntryIngredients::ofItemStacks).toList();
        this.outputs = this.recipe.getOutputs().stream().map(EntryIngredients::ofItemStacks).toList();
    }

    public ReiDisplay(R recipe, ResourceLocation id, ReiType<R> category) {
        this(new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id), recipe), category);
    }

    public R getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<ReiDisplay<R>> getCategoryIdentifier() {
        return this.category.getId();
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.getId());
    }

    @Nullable
    public DisplaySerializer<ReiDisplay<R>> getSerializer() {
        return this.category.getSerializer();
    }
}

