/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Item2DWidget
extends WidgetWithBounds {
    private static final int SLOT_SIZE = 18;
    private int x = 0;
    private int y = 0;
    private int cols = 0;
    private int rows = 0;
    private transient BiFunction<Integer, Integer, Collection<? extends EntryStack<?>>> itemProvider = (x, y) -> EntryIngredients.of((ItemStack)ItemStack.EMPTY);
    private transient Slot[][] slots = new Slot[0][0];

    @NotNull
    public Item2DWidget x(int x) {
        this.x = x;
        return this;
    }

    @NotNull
    public Item2DWidget y(int y) {
        this.y = y;
        return this;
    }

    @NotNull
    public Item2DWidget items(@NotNull BiFunction<Integer, Integer, Collection<? extends EntryStack<?>>> itemProvider) {
        this.itemProvider = itemProvider;
        this.slots = new Slot[this.rows][this.cols];
        return this;
    }

    @NotNull
    public Item2DWidget cols(int cols) {
        this.cols = cols;
        this.slots = new Slot[this.rows][this.cols];
        return this;
    }

    @NotNull
    public Item2DWidget rows(int rows) {
        this.rows = rows;
        this.slots = new Slot[this.rows][this.cols];
        return this;
    }

    public Slot get(int x, int y) throws ArrayIndexOutOfBoundsException {
        Slot slot = this.slots[y][x];
        if (slot == null) {
            this.slots[y][x] = slot = Widgets.createSlot((Point)new Point(this.x + (x + 1) * 18, this.y + (y + 1) * 18)).entries(this.itemProvider.apply(x, y)).interactable(true).markInput();
        }
        return slot;
    }

    public int width() {
        return (this.cols + 2) * 18;
    }

    public int height() {
        return (this.rows + 2) * 18;
    }

    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width(), this.height());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (int x = 0; x < this.cols; ++x) {
            for (int y = 0; y < this.rows; ++y) {
                this.get(x, y).render(graphics, mouseX, mouseY, delta);
            }
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    @NotNull
    public List<Slot> children() {
        ArrayList<Slot> slots = new ArrayList<Slot>(this.rows * this.cols);
        for (int x = 0; x < this.rows; ++x) {
            for (int y = 0; y < this.cols; ++y) {
                slots.add(this.get(x, y));
            }
        }
        return slots;
    }

    public static Item2DWidget create() {
        return new Item2DWidget();
    }
}

