/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.compat.rei.widget;

import com.mojang.math.Transformation;
import cool.muyucloud.croparia.util.CifUtil;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class PatchedTranslatable
extends DelegateWidget {
    private final Supplier<Matrix4f> translate;

    public PatchedTranslatable(WidgetWithBounds widget, Supplier<Matrix4f> translate) {
        super((Widget)widget);
        this.translate = translate;
    }

    protected Matrix4f translate() {
        return this.translate.get();
    }

    protected final Matrix4f inverseTranslate() {
        return MatrixUtils.inverse((Matrix4f)this.translate());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushPose();
        graphics.pose().last().pose().mul((Matrix4fc)this.translate());
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        super.render(graphics, CifUtil.toIntSafe(mouse.x()), CifUtil.toIntSafe(mouse.y()), delta);
        graphics.pose().popPose();
    }

    private Vector4f transformMouse(double mouseX, double mouseY) {
        Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
        this.inverseTranslate().transform(mouse);
        return mouse;
    }

    public boolean containsMouse(double mouseX, double mouseY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.containsMouse((double)mouse.x(), (double)mouse.y());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        Optional optional = this.getChildAt(mouseX = (double)mouse.x(), mouseY = (double)mouse.y());
        if (optional.isEmpty()) {
            return false;
        }
        GuiEventListener guiEventListener = (GuiEventListener)optional.get();
        if (guiEventListener.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseReleased((double)mouse.x(), (double)mouse.y(), button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseDragged((double)mouse.x(), (double)mouse.y(), button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseScrolled((double)mouse.x(), (double)mouse.y(), amountX, amountY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse((Matrix4f)this.inverseTranslate());
            boolean bl = super.keyPressed(keyCode, scanCode, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse((Matrix4f)this.inverseTranslate());
            boolean bl = super.keyReleased(keyCode, scanCode, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean charTyped(char character, int modifiers) {
        try {
            Widget.translateMouse((Matrix4f)this.inverseTranslate());
            boolean bl = super.charTyped(character, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    public double getZRenderingPriority() {
        Transformation transformation = new Transformation(this.translate());
        return (double)transformation.getTranslation().z() + super.getZRenderingPriority();
    }

    public Rectangle getBounds() {
        return MatrixUtils.transform((Matrix4f)this.translate(), (Rectangle)super.getBounds());
    }
}

