/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.config;

import cool.muyucloud.croparia.config.RawConfig;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    @NotNull
    private Path filePath;
    private Path recipeWizard;
    @NotNull
    private Boolean override;
    @NotNull
    private Boolean infusor;
    @NotNull
    private Boolean ritual;
    @NotNull
    private Boolean fruitUse;
    @NotNull
    private Integer autoReload;
    @NotNull
    private Integer soakAttempts;
    @NotNull
    private final List<ResourceLocation> cropBlackList;
    private final List<String> modBlackList;

    @NotNull
    public static Optional<Path> parsePath(@Nullable String path) {
        if (path == null) {
            return Optional.empty();
        }
        Path p = Path.of(path, new String[0]);
        if (p.isAbsolute()) {
            return Optional.of(p);
        }
        return Optional.of(Platform.getGameFolder().resolve(path));
    }

    @NotNull
    public static String resolvePath(@NotNull Path path) {
        Path normalizedBasePath;
        Path normalizedPath = path.normalize();
        if (normalizedPath.startsWith(normalizedBasePath = Platform.getGameFolder().normalize())) {
            return normalizedBasePath.relativize(normalizedPath).toString();
        }
        return normalizedPath.toAbsolutePath().toString();
    }

    public Config() {
        this.filePath = Platform.getGameFolder().resolve("croparia");
        this.recipeWizard = Platform.getGameFolder().resolve("croparia/recipe_wizard/dump");
        this.autoReload = 20;
        this.override = true;
        this.fruitUse = true;
        this.infusor = true;
        this.ritual = true;
        this.soakAttempts = 1;
        this.cropBlackList = new ArrayList<ResourceLocation>();
        this.modBlackList = new ArrayList<String>();
    }

    public Config(RawConfig raw) {
        this.filePath = Config.parsePath(raw.filePath()).orElse(Platform.getGameFolder().resolve("croparia"));
        this.recipeWizard = Config.parsePath(raw.recipeWizard()).orElse(Platform.getGameFolder().resolve("croparia/recipe_wizard/dump"));
        this.autoReload = raw.autoReload() != null ? raw.autoReload() : 20;
        this.override = raw.override() != null ? raw.override() : true;
        this.fruitUse = raw.fruitUse() != null ? raw.fruitUse() : true;
        this.infusor = raw.infusor() != null ? raw.infusor() : true;
        this.ritual = raw.ritual() != null ? raw.ritual() : true;
        this.soakAttempts = raw.soakAttempts() != null ? raw.soakAttempts() : 1;
        this.cropBlackList = new ArrayList<ResourceLocation>();
        this.modBlackList = new ArrayList<String>();
        this.setBlackList(raw.blacklist());
    }

    public RawConfig toRaw() {
        return new RawConfig(Config.resolvePath(this.filePath), Config.resolvePath(this.recipeWizard), this.override, this.infusor, this.ritual, this.fruitUse, this.autoReload, this.soakAttempts, this.getBlacklist());
    }

    @NotNull
    public Path getFilePath() {
        return this.filePath;
    }

    public void setFilePath(@NotNull Path filePath) {
        this.filePath = filePath;
    }

    @NotNull
    public Path getRecipeWizard() {
        return this.recipeWizard;
    }

    public void setRecipeWizard(@NotNull Path recipeWizard) {
        this.recipeWizard = recipeWizard;
    }

    @NotNull
    public Integer getAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(@NotNull Integer autoReload) {
        this.autoReload = autoReload;
    }

    @NotNull
    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(@NotNull Boolean override) {
        this.override = override;
    }

    @NotNull
    public Boolean getFruitUse() {
        return this.fruitUse;
    }

    public void setFruitUse(@NotNull Boolean fruitUse) {
        this.fruitUse = fruitUse;
    }

    @NotNull
    public Boolean getInfusor() {
        return this.infusor;
    }

    public void setInfusor(@NotNull Boolean infusor) {
        this.infusor = infusor;
    }

    @NotNull
    public Integer getSoakAttempts() {
        return this.soakAttempts;
    }

    public void setSoakAttempts(@NotNull Integer soakAttempts) {
        this.soakAttempts = soakAttempts;
    }

    @NotNull
    public Boolean getRitual() {
        return this.ritual;
    }

    public void setRitual(@NotNull Boolean ritual) {
        this.ritual = ritual;
    }

    @NotNull
    public List<ResourceLocation> getCropBlackList() {
        return this.cropBlackList;
    }

    @NotNull
    public List<String> getModBlackList() {
        return this.modBlackList;
    }

    public List<String> getBlacklist() {
        ArrayList<String> blacklist = new ArrayList<String>(this.getCropBlackList().size() + this.getModBlackList().size());
        for (ResourceLocation id : this.getCropBlackList()) {
            blacklist.add(id.toString());
        }
        for (String token : this.getModBlackList()) {
            blacklist.add("@" + token);
        }
        return blacklist;
    }

    public void setBlackList(@NotNull List<String> blacklist) {
        this.getCropBlackList().clear();
        this.getModBlackList().clear();
        for (String token : blacklist) {
            if (token.startsWith("@")) {
                this.getModBlackList().add(token.substring(1));
                continue;
            }
            ResourceLocation id = ResourceLocation.tryParse((String)token);
            if (id == null) continue;
            this.getCropBlackList().add(id);
        }
    }

    public boolean isCropValid(ResourceLocation id) {
        for (ResourceLocation e : this.getCropBlackList()) {
            if (!e.equals((Object)id)) continue;
            return false;
        }
        return true;
    }

    public boolean isModValid(String mod) {
        for (String token : this.getModBlackList()) {
            if (!Pattern.compile(token).matcher(mod).matches()) continue;
            return false;
        }
        return true;
    }
}

