/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.mixin;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.generator.DataGenerator;
import cool.muyucloud.croparia.api.generator.pack.DataPackHandler;
import cool.muyucloud.croparia.api.generator.pack.PackHandler;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PackRepository.class})
public abstract class PackRepositoryMixin {
    @Inject(method={"reload()V"}, at={@At(value="HEAD")})
    private void onReload(CallbackInfo ci) {
        CropariaIf.getServer().ifPresentOrElse(server -> {
            if (server.isSameThread()) {
                this.cif$trigger();
            }
        }, this::cif$trigger);
    }

    @Unique
    private void cif$trigger() {
        DataGenerator.LOGGER.debug("=== Data Pack Reload Triggered ===");
        DataPackHandler.REGISTRY.values().forEach(PackHandler::onTriggered);
    }

    @ModifyVariable(method={"<init>([Lnet/minecraft/server/packs/repository/RepositorySource;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private static RepositorySource[] insertProviders(RepositorySource ... providers) {
        DataGenerator.LOGGER.debug("=== Inserting Data Pack Providers ===");
        RepositorySource[] newProviders = new RepositorySource[providers.length + DataPackHandler.REGISTRY.size()];
        int i = 0;
        for (DataPackHandler pack : DataPackHandler.REGISTRY.values()) {
            newProviders[i] = pack.getDatapack();
            ++i;
        }
        RepositorySource[] repositorySourceArray = providers;
        int n = repositorySourceArray.length;
        for (int j = 0; j < n; ++j) {
            RepositorySource source;
            newProviders[i] = source = repositorySourceArray[j];
            ++i;
        }
        return newProviders;
    }
}

