/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.registry;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.api.core.block.ActivatedShrieker;
import cool.muyucloud.croparia.api.core.block.ElementalStone;
import cool.muyucloud.croparia.api.core.block.Greenhouse;
import cool.muyucloud.croparia.api.core.block.Infusor;
import cool.muyucloud.croparia.api.core.block.Placeholder;
import cool.muyucloud.croparia.api.core.block.RitualStand;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class CropariaBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"croparia", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<ActivatedShrieker> ACTIVATED_SHRIEKER = CropariaBlocks.registerBlock("activated_shrieker", (BlockBehaviour.Properties properties) -> new ActivatedShrieker(properties.mapColor(MapColor.COLOR_BLACK).strength(3.0f, 3.0f).sound(SoundType.SCULK_SHRIEKER)));
    public static final RegistrySupplier<Placeholder> PLACEHOLDER = CropariaBlocks.registerBlock("placeholder_block", Placeholder::new);
    public static final RegistrySupplier<Greenhouse> GREENHOUSE = CropariaBlocks.registerBlock("greenhouse", (BlockBehaviour.Properties properties) -> new Greenhouse(properties.strength(1.0f, 1.0f).randomTicks().lightLevel(state -> 8).isSuffocating((state, world, pos) -> false).isViewBlocking((state, world, pos) -> false)));
    public static final RegistrySupplier<Infusor> INFUSOR = CropariaBlocks.registerBlock("infusor", (BlockBehaviour.Properties properties) -> new Infusor(properties.strength(1.0f, 1.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<RitualStand> RITUAL_STAND = CropariaBlocks.registerBlock("ritual_stand", (BlockBehaviour.Properties properties) -> new RitualStand(properties.strength(1.0f, 1.0f).sound(SoundType.ANVIL).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<RitualStand> RITUAL_STAND_2 = CropariaBlocks.registerBlock("ritual_stand_2", (BlockBehaviour.Properties properties) -> new RitualStand(properties.strength(1.0f, 1.0f).sound(SoundType.ANVIL).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<RitualStand> RITUAL_STAND_3 = CropariaBlocks.registerBlock("ritual_stand_3", (BlockBehaviour.Properties properties) -> new RitualStand(properties.strength(1.0f, 1.0f).sound(SoundType.ANVIL).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<Block> ELEMENTAL_STONE = CropariaBlocks.registerBlock("elemental_stone", (BlockBehaviour.Properties properties) -> new ElementalStone(properties.strength(1.0f, 1.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<DropExperienceBlock> ELEMATILIUS_ORE = CropariaBlocks.registerBlock("elematilius_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), properties.strength(1.0f, 1.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<DropExperienceBlock> DEEPSLATE_ELEMATILIUS_ORE = CropariaBlocks.registerBlock("deepslate_elematilius_ore", (BlockBehaviour.Properties properties) -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), properties.strength(1.0f, 1.0f).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).sound(SoundType.DEEPSLATE)));

    public static <T extends Block> RegistrySupplier<T> registerBlock(@NotNull String name, @NotNull Function<BlockBehaviour.Properties, T> supplier) {
        return BLOCKS.register(name, () -> (Block)supplier.apply(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)CropariaIf.of(name)))));
    }

    public static <T extends Block> RegistrySupplier<T> registerBlock(@NotNull ResourceLocation id, @NotNull Function<BlockBehaviour.Properties, T> supplier) {
        return BLOCKS.register(id, () -> (Block)supplier.apply(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id))));
    }

    public static void register() {
        CropariaIf.LOGGER.debug("Registering blocks");
        BLOCKS.register();
    }
}

