/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.registry;

import cool.muyucloud.croparia.CropariaIf;
import cool.muyucloud.croparia.annotation.PostReg;
import cool.muyucloud.croparia.api.core.item.GreenhouseItem;
import cool.muyucloud.croparia.api.core.item.Placeholder;
import cool.muyucloud.croparia.api.core.item.RecipeWizard;
import cool.muyucloud.croparia.api.core.item.relic.HornPlenty;
import cool.muyucloud.croparia.api.core.item.relic.InfiniteApple;
import cool.muyucloud.croparia.api.core.item.relic.MagicRope;
import cool.muyucloud.croparia.api.core.item.relic.MidasHand;
import cool.muyucloud.croparia.api.crop.item.Croparia;
import cool.muyucloud.croparia.registry.CropariaBlocks;
import cool.muyucloud.croparia.registry.Tabs;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CropariaItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"croparia", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<RecipeWizard> RECIPE_WIZARD = CropariaItems.registerItem("recipe_wizard", (Item.Properties properties) -> new RecipeWizard(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CropariaIf.of("recipe_wizard"))).arch$tab(Tabs.MAIN).rarity(Rarity.UNCOMMON).stacksTo(1)));
    public static final RegistrySupplier<BlockItem> ACTIVATED_SHRIEKER = CropariaItems.registerItem("activated_shrieker", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.ACTIVATED_SHRIEKER.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> PLACEHOLDER_BLOCK = CropariaItems.registerItem("placeholder_block", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.PLACEHOLDER.get(), properties));
    public static final RegistrySupplier<Placeholder> PLACEHOLDER = CropariaItems.registerItem("placeholder", (Item.Properties properties) -> new Placeholder(properties.stacksTo(99)));
    public static final RegistrySupplier<BlockItem> GREENHOUSE = CropariaItems.registerItem("greenhouse", (Item.Properties properties) -> new GreenhouseItem((Block)CropariaBlocks.GREENHOUSE.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> INFUSOR = CropariaItems.registerItem("infusor", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.INFUSOR.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> RITUAL_STAND = CropariaItems.registerItem("ritual_stand", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> RITUAL_STAND_2 = CropariaItems.registerItem("ritual_stand_2", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND_2.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> RITUAL_STAND_3 = CropariaItems.registerItem("ritual_stand_3", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.RITUAL_STAND_3.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> ELEMENTAL_STONE = CropariaItems.registerItem("elemental_stone", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.ELEMENTAL_STONE.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> ELEMATILIUS_ORE = CropariaItems.registerItem("elematilius_ore", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.ELEMATILIUS_ORE.get(), properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<BlockItem> DEEPSLATE_ELEMATILIUS_ORE = CropariaItems.registerItem("deepslate_elematilius_ore", (Item.Properties properties) -> new BlockItem((Block)CropariaBlocks.DEEPSLATE_ELEMATILIUS_ORE.get(), properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA = CropariaItems.registerItem("croparia", (Item.Properties properties) -> new Croparia(1, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA2 = CropariaItems.registerItem("croparia2", (Item.Properties properties) -> new Croparia(2, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA3 = CropariaItems.registerItem("croparia3", (Item.Properties properties) -> new Croparia(3, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA4 = CropariaItems.registerItem("croparia4", (Item.Properties properties) -> new Croparia(4, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA5 = CropariaItems.registerItem("croparia5", (Item.Properties properties) -> new Croparia(5, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA6 = CropariaItems.registerItem("croparia6", (Item.Properties properties) -> new Croparia(6, properties.arch$tab(Tabs.MAIN)));
    @PostReg
    public static final RegistrySupplier<Item> CROPARIA7 = CropariaItems.registerItem("croparia7", (Item.Properties properties) -> new Croparia(7, properties.arch$tab(Tabs.MAIN)));
    public static final RegistrySupplier<HornPlenty> HORN = CropariaItems.registerItem("horn_plenty", (Item.Properties properties) -> new HornPlenty(properties.arch$tab(Tabs.MAIN).stacksTo(1).rarity(Rarity.EPIC)));
    public static final RegistrySupplier<InfiniteApple> INFINITE_APPLE = CropariaItems.registerItem("infinite_apple", (Item.Properties properties) -> new InfiniteApple(properties.food(new FoodProperties.Builder().alwaysEdible().nutrition(5).saturationModifier(4.0f).build(), Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(List.of(new MobEffectInstance(MobEffects.REGENERATION, 100, 1), new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, 0), new MobEffectInstance(MobEffects.ABSORPTION, 100, 3)))).build()).stacksTo(1).arch$tab(Tabs.MAIN).rarity(Rarity.EPIC)));
    public static final RegistrySupplier<MagicRope> MAGIC_ROPE = CropariaItems.registerItem("magic_rope", (Item.Properties properties) -> new MagicRope(properties.arch$tab(Tabs.MAIN).rarity(Rarity.EPIC).stacksTo(1)));
    public static final RegistrySupplier<MidasHand> MIDAS_HAND = CropariaItems.registerItem("midas_hand", (Item.Properties properties) -> new MidasHand(properties.arch$tab(Tabs.MAIN).rarity(Rarity.EPIC).stacksTo(1)));
    protected static final List<RegistrySupplier<Item>> CROPARIAS = List.of(CROPARIA, CROPARIA2, CROPARIA3, CROPARIA4, CROPARIA5, CROPARIA6, CROPARIA7);
    protected static final List<RegistrySupplier<BlockItem>> RITUAL_STANDS = List.of(RITUAL_STAND, RITUAL_STAND_2, RITUAL_STAND_3);

    @NotNull
    public static <T extends Item> RegistrySupplier<T> registerItem(@NotNull String name, @NotNull Function<Item.Properties, T> supplier) {
        return ITEMS.register(name, () -> (Item)supplier.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CropariaIf.of(name)))));
    }

    @NotNull
    public static <T extends Item> RegistrySupplier<T> registerItem(@NotNull ResourceLocation id, @NotNull Function<Item.Properties, T> supplier) {
        return ITEMS.register(id, () -> (Item)supplier.apply(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id))));
    }

    public static void register() {
        CropariaIf.LOGGER.debug("Registering items");
        ITEMS.register();
    }

    @NotNull
    public static RegistrySupplier<Item> getCroparia(int tier) {
        return CROPARIAS.get(tier - 1);
    }

    public static int leastTier() {
        return 1;
    }

    public static int mostTier() {
        return CROPARIAS.size();
    }

    @NotNull
    public static RegistrySupplier<BlockItem> getRitualStand(int tier) {
        return RITUAL_STANDS.get(tier - 1);
    }
}

