/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DynamicProperty<T extends Comparable<T>>
extends Property<T> {
    private final Supplier<BiMap<String, T>> map;

    public DynamicProperty(String name, Class<T> tClass, Supplier<BiMap<String, T>> map) {
        super(name, tClass);
        this.map = map;
    }

    @NotNull
    public List<T> getPossibleValues() {
        return this.map.get().values().stream().toList();
    }

    @NotNull
    public String getName(T value) {
        return (String)this.map.get().inverse().get(value);
    }

    @NotNull
    public Optional<T> getValue(String string) {
        return Optional.ofNullable((Comparable)this.map.get().get((Object)string));
    }

    public int getInternalIndex(T value) {
        return this.getPossibleValues().indexOf(value);
    }
}

