/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util;

import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

@Immutable
public class RangedVec3i
extends Vec3i {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final int hash;

    public static RangedVec3i maxBounds(int maxX, int maxY, int maxZ, int x, int y, int z) {
        return new RangedVec3i(0, 0, 0, maxX, maxY, maxZ, x, y, z);
    }

    public static RangedVec3i maxBounds(int maxX, int maxY, int maxZ) {
        return RangedVec3i.maxBounds(maxX, maxY, maxZ, 0, 0, 0);
    }

    public static RangedVec3i bounds(int x, int y, int z, int length, int width, int height) {
        return new RangedVec3i(x, y, z, x + length, y + width, z + height, x, y, z);
    }

    public RangedVec3i(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int x, int y, int z) {
        super(Math.min(Math.max(minX, x), maxX), Math.min(Math.max(minY, y), maxY), Math.min(Math.max(minZ, z), maxZ));
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            throw new IllegalArgumentException("Min values must be less than or equal to max values");
        }
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.hash = Objects.hash(minX, minY, minZ, maxX, maxY, maxZ, this.getX(), this.getY(), this.getZ());
    }

    public boolean isInside(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean isInside(Vec3i vec) {
        return this.isInside(vec.getX(), vec.getY(), vec.getZ());
    }

    public int volume() {
        return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1) * (this.maxZ - this.minZ + 1);
    }

    @NotNull
    public RangedVec3i multiply(int scalar) {
        return scalar == 0 ? this : new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.getX() * scalar, this.getY() * scalar, this.getZ() * scalar);
    }

    @NotNull
    public RangedVec3i relative(@NotNull Direction direction, int distance) {
        return distance == 0 ? this : this.offset(direction.getStepX() * distance, direction.getStepY() * distance, direction.getStepZ() * distance);
    }

    @NotNull
    public RangedVec3i relative(@NotNull Direction.Axis axis, int amount) {
        return amount == 0 ? this : this.relative(axis.getPositive(), amount);
    }

    @NotNull
    public RangedVec3i cross(@NotNull Vec3i vector) {
        return new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.getY() * vector.getZ() - this.getZ() * vector.getY(), this.getZ() * vector.getX() - this.getX() * vector.getZ(), this.getX() * vector.getY() - this.getY() * vector.getX());
    }

    public RangedVec3i min(int minX, int minY, int minZ) {
        return new RangedVec3i(minX, minY, minZ, this.maxX, this.maxY, this.maxZ, this.getX(), this.getY(), this.getZ());
    }

    public RangedVec3i min(@NotNull Vec3i min) {
        return this.min(min.getX(), min.getY(), min.getZ());
    }

    public RangedVec3i minX(int minX) {
        return this.min(minX, this.minY, this.minZ);
    }

    public RangedVec3i minY(int minY) {
        return this.min(this.minX, minY, this.minZ);
    }

    public RangedVec3i minZ(int minZ) {
        return this.min(this.minX, this.minY, minZ);
    }

    public RangedVec3i max(int maxX, int maxY, int maxZ) {
        return new RangedVec3i(this.minX, this.minY, this.minZ, maxX, maxY, maxZ, this.getX(), this.getY(), this.getZ());
    }

    public RangedVec3i max(@NotNull Vec3i max) {
        return this.max(max.getX(), max.getY(), max.getZ());
    }

    public RangedVec3i maxX(int maxX) {
        return this.max(maxX, this.maxY, this.maxZ);
    }

    public RangedVec3i maxY(int maxY) {
        return this.max(this.maxX, maxY, this.maxZ);
    }

    public RangedVec3i maxZ(int maxZ) {
        return this.max(this.maxX, this.maxY, maxZ);
    }

    @NotNull
    public RangedVec3i offset(int dx, int dy, int dz) {
        return this.rebuild(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    public RangedVec3i rebuild(int x, int y, int z) {
        RangedVec3i result = new RangedVec3i(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, x, y, z);
        if (result.equals((Object)this)) {
            return this;
        }
        return result;
    }

    public RangedVec3i rebuild(@NotNull Vec3i vec) {
        return this.rebuild(vec.getX(), vec.getY(), vec.getZ());
    }

    public RangedVec3i x(int x) {
        return this.rebuild(x, this.getY(), this.getZ());
    }

    public RangedVec3i y(int y) {
        return this.rebuild(this.getX(), y, this.getZ());
    }

    public RangedVec3i z(int z) {
        return this.rebuild(this.getX(), this.getY(), z);
    }

    public RangedVec3i dx(int dx) {
        return this.x(this.getX() + dx);
    }

    public RangedVec3i dy(int dy) {
        return this.y(this.getY() + dy);
    }

    public RangedVec3i dz(int dz) {
        return this.z(this.getZ() + dz);
    }

    public boolean testX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean testY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean testZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @NotNull
    public RangedVec3i above() {
        return this.above(1);
    }

    @NotNull
    public RangedVec3i above(int distance) {
        return this.relative(Direction.UP, distance);
    }

    @NotNull
    public RangedVec3i below() {
        return this.below(1);
    }

    @NotNull
    public RangedVec3i below(int distance) {
        return this.relative(Direction.DOWN, distance);
    }

    @NotNull
    public RangedVec3i north() {
        return this.north(1);
    }

    @NotNull
    public RangedVec3i north(int distance) {
        return this.relative(Direction.NORTH, distance);
    }

    @NotNull
    public RangedVec3i south() {
        return this.south(1);
    }

    @NotNull
    public RangedVec3i south(int distance) {
        return this.relative(Direction.SOUTH, distance);
    }

    @NotNull
    public RangedVec3i west() {
        return this.west(1);
    }

    @NotNull
    public RangedVec3i west(int distance) {
        return this.relative(Direction.WEST, distance);
    }

    @NotNull
    public RangedVec3i east() {
        return this.east(1);
    }

    @NotNull
    public RangedVec3i east(int distance) {
        return this.relative(Direction.EAST, distance);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof RangedVec3i) {
            RangedVec3i that = (RangedVec3i)((Object)o);
            return this.minX == that.minX && this.minY == that.minY && this.minZ == that.minZ && this.maxX == that.maxX && this.maxY == that.maxY && this.maxZ == that.maxZ;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

