/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.croparia.util.supplier;

import cool.muyucloud.croparia.util.supplier.Mappable;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazySupplier<T>
implements Mappable<T> {
    protected Supplier<T> creator;
    protected T cache;
    protected boolean loaded = false;

    public static <T> LazySupplier<T> empty() {
        return LazySupplier.of(() -> null);
    }

    public static <T> LazySupplier<T> of(Supplier<T> creator) {
        return creator.getClass() == LazySupplier.class ? (LazySupplier<T>)creator : new LazySupplier<T>(creator);
    }

    public LazySupplier(Supplier<T> creator) {
        this.creator = creator;
    }

    @Override
    public <O, M extends O> LazySupplier<O> map(Function<T, M> mapper) {
        return new LazySupplier<Object>(() -> mapper.apply(this.get()));
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public T get() {
        if (!this.loaded) {
            this.cache = this.creator.get();
            this.loaded = true;
        }
        return this.cache;
    }
}

