{
  id: "thufizerdomination",
  onStart(pokemon) {
    this.add("-ability", pokemon, "Thufizer Domination");
    this.add(`${pokemon.name}'s three heads take charge.`);
    this.add(`${pokemon.name}'s Moltres head takes over!`);
    pokemon.thufizerHead = 'moltres';
    pokemon.thufizerTurnCount = 0;
  },

  onResidual(pokemon) {
    pokemon.thufizerTurnCount++;
    if (pokemon.thufizerTurnCount % 3 === 0) {
      if (pokemon.thufizerHead === 'moltres') {
        pokemon.thufizerHead = 'zapdos';
        this.add(`${pokemon.name}'s Zapdos head takes over!`);
      } else if (pokemon.thufizerHead === 'zapdos') {
        pokemon.thufizerHead = 'articuno';
        this.add(`${pokemon.name}'s Articuno head takes over!`);
      } else {
        pokemon.thufizerHead = 'moltres';
        this.add(`${pokemon.name}'s Moltres head takes over!`);
      }
    }
  },

  onBasePower(basePower, attacker, defender, move) {
    if (['Fire', 'Ice', 'Electric'].includes(move.type)) {
      return this.chainModify(1.33);
    }
  },

  onModifyMove(move, pokemon) {
    if (['Fire', 'Ice', 'Electric'].includes(move.type) && typeof move.accuracy === 'number') {
      move.accuracy = Math.min(100, Math.ceil(move.accuracy * 1.33));
    }
    if (move.type === 'Electric' && pokemon.thufizerHead === 'zapdos') {
      move.accuracy = true;
    }
  },

  onModifyPriority(priority, pokemon, target, move) {
    if (move.type === 'Ice' && pokemon.thufizerHead === 'articuno') {
      return priority + 1;
    }
  },

  onAfterMove(source, target, move) {
    if (!target || target.side === source.side) return;
    if (move.category === 'Status') return;
    if (move.type === 'Fire' && source.thufizerHead === 'moltres') {
      target.trySetStatus('brn', source, move);
      this.boost({spa: 1}, source);
    } else if (move.type === 'Electric' && source.thufizerHead === 'zapdos') {
      this.boost({spe: 1}, source);
    } else if (move.type === 'Ice' && source.thufizerHead === 'articuno') {
      if (this.randomChance(75, 100)) {
        target.trySetStatus('frz', source, move);
      }
      this.boost({spd: 1}, source);
    }
  },

  flags: { breakable: 1 },
  name: "Thufizer Domination",
  rating: 10,
  num: -780
}