package me.pajic.soaring_phantoms.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.soaring_phantoms.SoaringPhantoms;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2910;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_2910.class)
public class PhantomSpawnerMixin {

    @Redirect(
            method = "tick",
            at = @At(
                    value = "FIELD",
                    opcode = Opcodes.PUTFIELD,
                    target = "Lnet/minecraft/world/level/levelgen/PhantomSpawner;nextTick:I",
                    ordinal = 1
            )
    )
    private void modifySpawnCheckFrequency(class_2910 instance, int value, @Local class_5819 randomSource) {
        instance.field_13244 += (SoaringPhantoms.CONFIG.spawnFrequencyBase.get() + randomSource.method_43048(SoaringPhantoms.CONFIG.spawnFrequencyRandomOffsetBound.get())) * 20;
    }

    @ModifyExpressionValue(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/level/ServerPlayer;isSpectator()Z"
            )
    )
    private boolean repelIfHoldingRepellentItem(boolean original, @Local class_3222 serverPlayer) {
        if (original || !SoaringPhantoms.CONFIG.phantomsRepelledByItem.get()) {
            return true;
        }
        return SoaringPhantoms.CONFIG.repellentItems.get().contains(class_7923.field_41178.method_10221(serverPlayer.method_5998(class_1268.field_5808).method_7909())) ||
				SoaringPhantoms.CONFIG.repellentItems.get().contains(class_7923.field_41178.method_10221(serverPlayer.method_5998(class_1268.field_5810).method_7909()));
    }

    @ModifyExpressionValue(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/RandomSource;nextInt(I)I",
                    ordinal = 1
            )
    )
    private int modifyCondition(int original, @Local class_2338 playerBlockPos, @Local class_5819 randomSource) {
        if (SoaringPhantoms.CONFIG.doAltitudeBasedSpawning.get()) {
            return randomSource.method_43048(playerBlockPos.method_10264());
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "tick",
            at = @At(
                    value = "CONSTANT",
                    args = "intValue=72000"
            )
    )
    private int modifyConditionCheckValue(int original, @Local(argsOnly = true) class_3218 level) {
        if (SoaringPhantoms.CONFIG.doAltitudeBasedSpawning.get()) {
            if (SoaringPhantoms.CONFIG.passivePhantomsBeforeEnderDragon.get()) {
                if (!level.method_8503().method_27728().method_29036().comp_1542()) {
                    return SoaringPhantoms.CONFIG.passiveSpawnStartHeight.get();
                }
            }
            return SoaringPhantoms.CONFIG.spawnStartHeight.get();
        }
        return original;
    }
}
