/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Content.Workbenchs;

import com.baizeli.eternisstarrysky.Content.Workbenchs.ModRecipeSerializers;
import com.baizeli.eternisstarrysky.Content.Workbenchs.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class VanillaWorkbenchRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final CraftingBookCategory category;
    private final NonNullList<Ingredient> recipeItems;
    public ItemStack result;
    public boolean shaped;
    public int width;
    public int height;

    public VanillaWorkbenchRecipe(ResourceLocation id, String group, CraftingBookCategory category, NonNullList<Ingredient> recipeItems, ItemStack result, boolean shaped, int width, int height) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.recipeItems = recipeItems;
        this.result = result;
        this.shaped = shaped;
        this.width = width;
        this.height = height;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.matchesShaped(container);
    }

    private boolean matchesShaped(Container container) {
        for (int i = 0; i <= 9 - this.width; ++i) {
            for (int j = 0; j <= 9 - this.height; ++j) {
                if (!this.matchesShapedAt(container, i, j, true) && !this.matchesShapedAt(container, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesShapedAt(Container container, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                ItemStack stack;
                int recipeX = x - startX;
                int recipeY = y - startY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (recipeX >= 0 && recipeY >= 0 && recipeX < this.width && recipeY < this.height) {
                    ingredient = mirrored ? (Ingredient)this.recipeItems.get(this.width - recipeX - 1 + recipeY * this.width) : (Ingredient)this.recipeItems.get(recipeX + recipeY * this.width);
                }
                if (ingredient.test(stack = container.m_8020_(x + y * 9))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchesShapeless(Container container) {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(this.recipeItems);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            boolean matched = false;
            for (int j = 0; j < ingredients.size(); ++j) {
                if (!((Ingredient)ingredients.get(j)).test(stack)) continue;
                ingredients.remove(j);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return ingredients.isEmpty();
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 9 && height >= 9;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.VANILLA_WORKBENCH_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.VANILLA_WORKBENCH_TYPE.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public static class Serializer
    implements RecipeSerializer<VanillaWorkbenchRecipe> {
        public VanillaWorkbenchRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            if (json.has("pattern")) {
                return this.fromJsonShaped(recipeId, json, group, category);
            }
            return this.fromJsonShapeless(recipeId, json, group, category);
        }

        private VanillaWorkbenchRecipe fromJsonShaped(ResourceLocation recipeId, JsonObject json, String group, CraftingBookCategory category) {
            JsonArray pattern = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
            String[] astring = new String[pattern.size()];
            for (int i = 0; i < astring.length; ++i) {
                String s;
                astring[i] = s = GsonHelper.m_13805_((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
            }
            JsonObject keyJson = GsonHelper.m_13930_((JsonObject)json, (String)"key");
            Map<String, Ingredient> map = Serializer.keyFromJson(keyJson);
            int width = astring[0].length();
            int height = astring.length;
            NonNullList<Ingredient> ingredients = Serializer.dissolvePattern(astring, map, width, height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new VanillaWorkbenchRecipe(recipeId, group, category, ingredients, result, true, width, height);
        }

        private VanillaWorkbenchRecipe fromJsonShapeless(ResourceLocation recipeId, JsonObject json, String group, CraftingBookCategory category) {
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsJson.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientsJson.get(i)));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new VanillaWorkbenchRecipe(recipeId, group, category, (NonNullList<Ingredient>)ingredients, result, false, 0, 0);
        }

        private static Map<String, Ingredient> keyFromJson(JsonObject keyJson) {
            HashMap<String, Ingredient> map = new HashMap<String, Ingredient>();
            for (Map.Entry entry : keyJson.entrySet()) {
                map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            map.put(" ", Ingredient.f_43901_);
            return map;
        }

        private static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
            NonNullList ingredients = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
            for (int i = 0; i < pattern.length; ++i) {
                String line = pattern[i];
                for (int j = 0; j < line.length(); ++j) {
                    String key = String.valueOf(line.charAt(j));
                    Ingredient ingredient = keys.get(key);
                    ingredients.set(j + patternWidth * i, (Object)ingredient);
                }
            }
            return ingredients;
        }

        @Nullable
        public VanillaWorkbenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            boolean shaped = buffer.readBoolean();
            int width = shaped ? buffer.m_130242_() : 0;
            int height = shaped ? buffer.m_130242_() : 0;
            int ingredientCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new VanillaWorkbenchRecipe(recipeId, group, category, (NonNullList<Ingredient>)ingredients, result, shaped, width, height);
        }

        public void toNetwork(FriendlyByteBuf buffer, VanillaWorkbenchRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130068_((Enum)recipe.category);
            buffer.writeBoolean(recipe.shaped);
            if (recipe.shaped) {
                buffer.m_130130_(recipe.width);
                buffer.m_130130_(recipe.height);
            }
            buffer.m_130130_(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

