/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Content.Workbenchs;

import com.baizeli.eternisstarrysky.Content.Workbenchs.ModMenuTypes;
import com.baizeli.eternisstarrysky.Content.Workbenchs.VanillaWorkbenchMenu;
import com.baizeli.eternisstarrysky.Content.Workbenchs.VanillaWorkbenchRecipe;
import com.baizeli.eternisstarrysky.Content.Workbenchs.VanillaWorkbenchRecipeCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.library.transfer.BasicRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class VanillaWorkbenchRecipeTransferHandler
extends BasicRecipeTransferHandler<VanillaWorkbenchMenu, VanillaWorkbenchRecipe> {
    public VanillaWorkbenchRecipeTransferHandler(IConnectionToServer serverConnection, IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IRecipeTransferInfo<VanillaWorkbenchMenu, VanillaWorkbenchRecipe> transferInfo) {
        super(serverConnection, stackHelper, handlerHelper, transferInfo);
    }

    public Class<? extends VanillaWorkbenchMenu> getContainerClass() {
        return VanillaWorkbenchMenu.class;
    }

    public Optional<MenuType<VanillaWorkbenchMenu>> getMenuType() {
        return Optional.of((MenuType)ModMenuTypes.VANILLA_WORKBENCH_MENU.get());
    }

    public RecipeType<VanillaWorkbenchRecipe> getRecipeType() {
        return VanillaWorkbenchRecipeCategory.RECIPE_TYPE;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(VanillaWorkbenchMenu container, VanillaWorkbenchRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (doTransfer) {
            return this.transferRecipeItems(container, recipe, player);
        }
        return this.validateTransfer(container, recipe, player);
    }

    @Nullable
    private IRecipeTransferError validateTransfer(VanillaWorkbenchMenu container, VanillaWorkbenchRecipe recipe, Player player) {
        HashMap<Ingredient, Integer> requiredItems = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (ingredient.m_43947_()) continue;
            requiredItems.put(ingredient, requiredItems.getOrDefault(ingredient, 0) + 1);
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            int available = 0;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!((Ingredient)entry.getKey()).test(stack)) continue;
                available += stack.m_41613_();
            }
        }
        return null;
    }

    @Nullable
    private IRecipeTransferError transferRecipeItems(VanillaWorkbenchMenu container, VanillaWorkbenchRecipe recipe, Player player) {
        this.clearCraftingGrid(container, player);
        if (recipe.shaped) {
            return this.transferShapedRecipe(container, recipe, player);
        }
        return this.transferShapelessRecipe(container, recipe, player);
    }

    private void clearCraftingGrid(VanillaWorkbenchMenu container, Player player) {
        int craftingSlotsEnd = 81;
        for (int i = 0; i < craftingSlotsEnd; ++i) {
            Slot slot = container.m_38853_(i);
            if (!slot.m_6657_()) continue;
            ItemStack stack = slot.m_6201_(slot.m_7993_().m_41613_());
            if (player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
    }

    @Nullable
    private IRecipeTransferError transferShapedRecipe(VanillaWorkbenchMenu container, VanillaWorkbenchRecipe recipe, Player player) {
        int bestStartX = 0;
        int bestStartY = 0;
        if (recipe.width < 9) {
            bestStartX = (9 - recipe.width) / 2;
        }
        if (recipe.height < 9) {
            bestStartY = (9 - recipe.height) / 2;
        }
        for (int recipeY = 0; recipeY < recipe.height; ++recipeY) {
            for (int recipeX = 0; recipeX < recipe.width; ++recipeX) {
                Ingredient ingredient;
                int ingredientIndex = recipeX + recipeY * recipe.width;
                if (ingredientIndex >= recipe.m_7527_().size() || (ingredient = (Ingredient)recipe.m_7527_().get(ingredientIndex)).m_43947_()) continue;
                int slotIndex = bestStartX + recipeX + (bestStartY + recipeY) * 9;
                ItemStack foundStack = this.findMatchingStackInInventory(player, ingredient);
                if (foundStack.m_41619_()) continue;
                ItemStack singleItem = foundStack.m_41620_(1);
                container.m_38853_(slotIndex).m_5852_(singleItem);
            }
        }
        return null;
    }

    @Nullable
    private IRecipeTransferError transferShapelessRecipe(VanillaWorkbenchMenu container, VanillaWorkbenchRecipe recipe, Player player) {
        int slotIndex = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (ingredient.m_43947_() || slotIndex >= 81) continue;
            ItemStack foundStack = this.findMatchingStackInInventory(player, ingredient);
            if (!foundStack.m_41619_()) {
                ItemStack singleItem = foundStack.m_41620_(1);
                container.m_38853_(slotIndex).m_5852_(singleItem);
            }
            ++slotIndex;
        }
        return null;
    }

    private ItemStack findMatchingStackInInventory(Player player, Ingredient ingredient) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!ingredient.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

