/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Entity;

import com.baizeli.eternisstarrysky.Entity.ModEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CustomArrowEntity
extends AbstractArrow {
    private boolean spawn = false;
    private boolean track = false;
    private long hitTime = -1L;
    private LivingEntity currentTarget = null;
    private long trackStartTime = -1L;
    private static final int TRACK_DURATION = 600;
    private static final double TRACK_RANGE = 30.0;
    private static final int TARGET_COOLDOWN = 20;
    private Map<LivingEntity, Long> attackedTargets = new HashMap<LivingEntity, Long>();

    public CustomArrowEntity(EntityType<? extends CustomArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CustomArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.CUSTOM_ARROW.get(), shooter, level);
    }

    public CustomArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.CUSTOM_ARROW.get(), x, y, z, level);
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    protected ItemStack m_7941_() {
        if (!this.spawn) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public void setTrack(boolean track) {
        this.track = track;
        if (track && this.trackStartTime == -1L) {
            this.trackStartTime = this.m_9236_().m_46467_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity hitEntity = result.m_82443_();
        if (hitEntity == this.m_19749_()) {
            return;
        }
        if (this.track && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            float damage = (float)this.m_36789_();
            DamageSource damageSource = this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_());
            if (livingEntity.m_6469_(damageSource, damage)) {
                livingEntity.f_19802_ = 0;
                livingEntity.f_20916_ = 0;
                this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                this.attackedTargets.put(livingEntity, this.m_9236_().m_46467_());
                this.currentTarget = this.findNextTarget();
                if (this.currentTarget == null) {
                    this.m_20242_(false);
                }
            }
            this.f_36703_ = false;
            return;
        }
        super.m_5790_(result);
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            livingEntity.f_19802_ = 0;
            livingEntity.f_20916_ = 0;
        }
        if (this.spawn) {
            this.createArrowRain();
        } else {
            this.hitTime = this.m_9236_().m_46467_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (this.track) {
            this.f_36703_ = false;
            return;
        }
        super.m_8060_(result);
        if (this.spawn) {
            this.createArrowRain();
        } else {
            this.hitTime = this.m_9236_().m_46467_();
        }
    }

    public void m_8119_() {
        long currentTime;
        if (this.track) {
            this.trackTarget();
        }
        super.m_8119_();
        if (!this.spawn && this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.spawn && !this.track && this.hitTime != -1L && (currentTime = this.m_9236_().m_46467_()) - this.hitTime >= 30L) {
            this.m_6074_();
        }
    }

    private boolean checkObstacleAbove(Vec3 center) {
        for (int y = 1; y <= 15; ++y) {
            BlockPos checkPos = new BlockPos((int)center.f_82479_, (int)center.f_82480_ + y, (int)center.f_82481_);
            if (this.m_9236_().m_8055_(checkPos).m_60795_()) continue;
            return true;
        }
        return false;
    }

    private void createVerticalArrowRain(Vec3 center, Random random) {
        for (int i = 0; i < 36; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double radius = random.nextDouble() * 9.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double spawnX = center.f_82479_ + offsetX;
            double spawnY = center.f_82480_ + 10.0 + random.nextDouble() * 10.0;
            double spawnZ = center.f_82481_ + offsetZ;
            CustomArrowEntity rainArrow = new CustomArrowEntity(this.m_9236_(), spawnX, spawnY, spawnZ);
            rainArrow.setSpawn(false);
            rainArrow.m_36781_(75.0);
            double targetX = center.f_82479_ + (random.nextDouble() - 0.5) * 8.0;
            double targetZ = center.f_82481_ + (random.nextDouble() - 0.5) * 8.0;
            Vec3 targetPos = new Vec3(targetX, center.f_82480_, targetZ);
            Vec3 direction = targetPos.m_82546_(rainArrow.m_20182_()).m_82541_();
            rainArrow.m_20256_(direction.m_82490_(1.5 + random.nextDouble() * 1.0));
            rainArrow.m_5602_(this.m_19749_());
            this.m_9236_().m_7967_((Entity)rainArrow);
        }
    }

    private void createHorizontalArrowRain(Vec3 center, Random random) {
        for (int i = 0; i < 36; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = 10.0 + random.nextDouble() * 5.0;
            double spawnX = center.f_82479_ + Math.cos(angle) * distance;
            double spawnY = center.f_82480_ + random.nextDouble() * 6.0 - 3.0;
            double spawnZ = center.f_82481_ + Math.sin(angle) * distance;
            BlockPos spawnPos = new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ);
            while (!this.m_9236_().m_8055_(spawnPos).m_60795_() && spawnY < center.f_82480_ + 10.0) {
                spawnPos = new BlockPos((int)spawnX, (int)(spawnY += 1.0), (int)spawnZ);
            }
            CustomArrowEntity rainArrow = new CustomArrowEntity(this.m_9236_(), spawnX, spawnY, spawnZ);
            rainArrow.setSpawn(false);
            rainArrow.m_36781_(75.0);
            double targetX = center.f_82479_ + (random.nextDouble() - 0.5) * 4.0;
            double targetY = center.f_82480_ + (random.nextDouble() - 0.5) * 2.0;
            double targetZ = center.f_82481_ + (random.nextDouble() - 0.5) * 4.0;
            Vec3 targetPos = new Vec3(targetX, targetY, targetZ);
            Vec3 direction = targetPos.m_82546_(rainArrow.m_20182_()).m_82541_();
            rainArrow.m_20256_(direction.m_82490_(2.0 + random.nextDouble() * 1.0));
            rainArrow.m_5602_(this.m_19749_());
            this.m_9236_().m_7967_((Entity)rainArrow);
        }
    }

    private void createArrowRain() {
        if (!this.m_9236_().f_46443_) {
            Vec3 center = this.m_20182_();
            Random random = new Random();
            boolean hasObstacleAbove = this.checkObstacleAbove(center);
            if (hasObstacleAbove) {
                this.createHorizontalArrowRain(center, random);
            } else {
                this.createVerticalArrowRain(center, random);
            }
        }
    }

    private LivingEntity findNextTarget() {
        if (this.m_9236_().f_46443_) {
            return null;
        }
        Vec3 arrowPos = this.m_20182_();
        LivingEntity nearestTarget = null;
        double nearestDistance = 30.0;
        long currentTime = this.m_9236_().m_46467_();
        this.attackedTargets.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 20L || !((LivingEntity)entry.getKey()).m_6084_());
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(30.0))) {
            double distance;
            if (entity == this.m_19749_() || !entity.m_6084_() || this.attackedTargets.containsKey(entity) || !((distance = entity.m_20182_().m_82554_(arrowPos)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = entity;
        }
        return nearestTarget;
    }

    private void trackTarget() {
        if (!this.track || this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_9236_().m_46467_() - this.trackStartTime > 600L) {
            this.m_6074_();
            return;
        }
        this.f_36703_ = false;
        if (this.currentTarget == null || !this.currentTarget.m_6084_() || this.attackedTargets.containsKey(this.currentTarget)) {
            this.currentTarget = this.findNextTarget();
        }
        if (this.currentTarget != null) {
            Vec3 targetPos = this.currentTarget.m_20182_().m_82520_(0.0, (double)(this.currentTarget.m_20206_() / 2.0f), 0.0);
            Vec3 arrowPos = this.m_20182_();
            Vec3 direction = targetPos.m_82546_(arrowPos).m_82541_();
            double speed = 2.0;
            this.m_20256_(direction.m_82490_(speed));
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
    }
}

