/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Items;

import com.baizeli.eternisstarrysky.Items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfinityEternalArmorItem
extends ArmorItem {
    public InfinityEternalArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (slot == EquipmentSlot.LEGS) {
            return "eternisstarrysky:textures/models/armor/null.png";
        }
        return "eternisstarrysky:textures/models/armor/null.png";
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (InfinityEternalArmorItem.hasFullSet(player)) {
                if (!player.m_150110_().f_35936_) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
                this.removeNegativeEffects(player);
                player.f_19789_ = 0.0f;
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
    }

    private void removeNegativeEffects(Player player) {
        ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
        for (MobEffectInstance effectInstance : player.m_21220_()) {
            MobEffect effect = effectInstance.m_19544_();
            if (effect.m_19486_()) continue;
            effectsToRemove.add(effect);
        }
        for (MobEffect effect : effectsToRemove) {
            player.m_21195_(effect);
        }
    }

    public static boolean hasFullSet(Player player) {
        ItemStack helmet = player.m_150109_().m_36052_(3);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack boots = player.m_150109_().m_36052_(0);
        return helmet.m_41720_() == ModItems.INFINITY_ETERNAL_HELMET.get() && chestplate.m_41720_() == ModItems.INFINITY_ETERNAL_CHESTPLATE.get() && leggings.m_41720_() == ModItems.INFINITY_ETERNAL_LEGGINGS.get() && boots.m_41720_() == ModItems.INFINITY_ETERNAL_BOOTS.get();
    }
}

