/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.config.menu;

import com.baizeli.eternisstarrysky.config.menu.ConfigValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.network.chat.Component;

public abstract class NumberValue
extends ConfigValue {
    public Number value;
    public Number min;
    public Number max;
    private String previous = "";

    public NumberValue(AbstractContainerEventHandler parent, String key, Font font) {
        super(parent, key, font);
        this.valueWidget = new EditBox(this.font, 0, 0, this.valueWidth, this.lineHeight, (Component)Component.m_237119_());
        ((EditBox)this.valueWidget).m_94151_(this::onChange);
    }

    @Override
    public void update() {
        EditBox box = (EditBox)this.valueWidget;
        box.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)(this.min + " ~ " + this.max))));
        if (box.m_93696_()) {
            return;
        }
        if (box.m_94155_().isEmpty()) {
            Number def = this.min;
            if (def.doubleValue() < 0.0) {
                def = 0;
            }
            this.previous = String.valueOf(def);
            box.m_94144_(this.previous);
        }
    }

    public void onChange(String value) {
        if (value.isEmpty()) {
            this.previous = value;
            return;
        }
        try {
            Number val = this.parseValue(value);
            if (!this.range(val)) {
                ((EditBox)this.valueWidget).m_94144_(this.previous);
                return;
            }
            this.value = val;
            this.previous = value;
        }
        catch (NumberFormatException e) {
            ((EditBox)this.valueWidget).m_94144_(this.previous);
        }
    }

    public abstract Number parseValue(String var1);

    public abstract boolean range(Number var1);

    public void value(Number v) {
        this.value = v;
        this.previous = String.valueOf(this.value);
        ((EditBox)this.valueWidget).m_94144_(this.previous);
    }
}

