/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Bypass;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BypassHelp {
    public static boolean out = false;

    public static void resetEntityAttribute(Entity entity, String attributeName) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        switch (attributeName) {
            case "damage": 
            case "attack": {
                living.m_21051_(Attributes.f_22281_).m_22100_(living.m_21051_(Attributes.f_22281_).m_22099_().m_22082_());
                break;
            }
            case "scale": 
            case "size": {
                break;
            }
            case "life": 
            case "health": {
                living.m_21051_(Attributes.f_22276_).m_22100_(living.m_21051_(Attributes.f_22276_).m_22099_().m_22082_());
                break;
            }
            case "speed": 
            case "movement": {
                living.m_21051_(Attributes.f_22279_).m_22100_(living.m_21051_(Attributes.f_22279_).m_22099_().m_22082_());
                break;
            }
            case "jump": 
            case "jump_strength": {
                living.m_21051_(Attributes.f_22288_).m_22100_(living.m_21051_(Attributes.f_22288_).m_22099_().m_22082_());
                break;
            }
            case "armor": {
                living.m_21051_(Attributes.f_22284_).m_22100_(0.0);
                break;
            }
            case "luck": {
                living.m_21051_(Attributes.f_22286_).m_22100_(0.0);
            }
        }
    }

    public static long parseTimeString(String[] parts, int startIndex) {
        long totalTime = 0L;
        for (int i = startIndex; i < parts.length; ++i) {
            String part = parts[i];
            try {
                if (part.endsWith("\u5929")) {
                    int days = Integer.parseInt(part.substring(0, part.length() - 1));
                    totalTime += TimeUnit.DAYS.toMillis(days);
                    continue;
                }
                if (part.endsWith("\u65f6")) {
                    int hours = Integer.parseInt(part.substring(0, part.length() - 1));
                    totalTime += TimeUnit.HOURS.toMillis(hours);
                    continue;
                }
                if (!part.endsWith("\u5206")) continue;
                int minutes = Integer.parseInt(part.substring(0, part.length() - 1));
                totalTime += TimeUnit.MINUTES.toMillis(minutes);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return totalTime;
    }

    public static boolean setEntityAttribute(Entity entity, String attributeName, String value) {
        try {
            switch (attributeName) {
                case "damage": 
                case "attack": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        double damageValue = Double.parseDouble(value);
                        living.m_21051_(Attributes.f_22281_).m_22100_(damageValue);
                        return true;
                    }
                    break;
                }
                case "scale": 
                case "size": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        float scaleValue = Float.parseFloat(value);
                        return true;
                    }
                    break;
                }
                case "life": 
                case "health": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        float healthValue = Float.parseFloat(value);
                        living.m_21051_(Attributes.f_22276_).m_22100_((double)healthValue);
                        living.m_21153_(healthValue);
                        return true;
                    }
                    break;
                }
                case "speed": 
                case "movement": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        double speedValue = Double.parseDouble(value);
                        living.m_21051_(Attributes.f_22279_).m_22100_(speedValue);
                        return true;
                    }
                    break;
                }
                case "jump": 
                case "jump_strength": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        double jumpValue = Double.parseDouble(value);
                        living.m_21051_(Attributes.f_22288_).m_22100_(jumpValue);
                        return true;
                    }
                    break;
                }
                case "armor": {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        double armorValue = Double.parseDouble(value);
                        living.m_21051_(Attributes.f_22284_).m_22100_(armorValue);
                        return true;
                    }
                    break;
                }
                case "luck": {
                    if (!(entity instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)entity;
                    double luckValue = Double.parseDouble(value);
                    living.m_21051_(Attributes.f_22286_).m_22100_(luckValue);
                    return true;
                }
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    public static Item getItemByName(String name) {
        List allItems;
        Item exactMatch;
        if (name.matches("[a-z0-9_:./-]+") && name.contains(":")) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation(name);
                if (BuiltInRegistries.f_257033_.m_7804_(resourceLocation)) {
                    return (Item)BuiltInRegistries.f_257033_.m_7745_(resourceLocation);
                }
            }
            catch (Exception resourceLocation) {
                // empty catch block
            }
        }
        if (name.matches("[a-z0-9_-]+")) {
            try {
                ResourceLocation minecraftLocation = new ResourceLocation("minecraft", name);
                if (BuiltInRegistries.f_257033_.m_7804_(minecraftLocation)) {
                    return (Item)BuiltInRegistries.f_257033_.m_7745_(minecraftLocation);
                }
            }
            catch (Exception minecraftLocation) {
                // empty catch block
            }
            Set namespaces = BuiltInRegistries.f_257033_.m_6566_().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
            for (String namespace : namespaces) {
                try {
                    ResourceLocation location = new ResourceLocation(namespace, name);
                    if (!BuiltInRegistries.f_257033_.m_7804_(location)) continue;
                    return (Item)BuiltInRegistries.f_257033_.m_7745_(location);
                }
                catch (Exception exception) {
                }
            }
        }
        if ((exactMatch = (Item)(allItems = BuiltInRegistries.f_257033_.m_123024_().collect(Collectors.toList())).stream().filter(item -> BypassHelp.getItemDisplayName(item).equals(name)).findFirst().orElse(null)) != null) {
            return exactMatch;
        }
        return allItems.stream().filter(item -> {
            String displayName = BypassHelp.getItemDisplayName(item);
            return displayName.contains(name) || displayName.toLowerCase().contains(name.toLowerCase());
        }).findFirst().orElse(null);
    }

    public static String getItemDisplayName(Item item) {
        return new ItemStack((ItemLike)item).m_41786_().getString();
    }

    public static List<Entity> findEntitiesByName(ServerPlayer player, String name, double range) {
        Vec3 playerPos = player.m_20182_();
        AABB searchBox = new AABB(playerPos.f_82479_ - range, playerPos.f_82480_ - range, playerPos.f_82481_ - range, playerPos.f_82479_ + range, playerPos.f_82480_ + range, playerPos.f_82481_ + range);
        List entities = player.m_9236_().m_45976_(Entity.class, searchBox).stream().filter(entity -> entity != player).collect(Collectors.toList());
        List<Entity> exactMatches = entities.stream().filter(entity -> {
            String displayName = BypassHelp.getEntityDisplayName(entity);
            String entityTypeName = entity.m_6095_().m_20676_().getString();
            return displayName.equals(name) || entityTypeName.equals(name);
        }).collect(Collectors.toList());
        if (!exactMatches.isEmpty()) {
            return exactMatches;
        }
        return entities.stream().filter(entity -> {
            String displayName = BypassHelp.getEntityDisplayName(entity);
            String entityTypeName = entity.m_6095_().m_20676_().getString();
            return displayName.contains(name) || entityTypeName.contains(name) || displayName.toLowerCase().contains(name.toLowerCase()) || entityTypeName.toLowerCase().contains(name.toLowerCase());
        }).collect(Collectors.toList());
    }

    public static String getEntityDisplayName(Entity entity) {
        return entity.m_5446_().getString();
    }

    public static void handleRemoveCommand(ServerPlayer player, String[] parts) {
        int removeLevel = 1;
        double range = 5.0;
        String targetName = null;
        if (parts.length > 1) {
            targetName = parts[1];
        }
        if (parts.length > 2) {
            try {
                removeLevel = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u79fb\u9664\u7b49\u7ea7\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                return;
            }
        }
        if (parts.length > 3) {
            try {
                range = Double.parseDouble(parts[3]);
            }
            catch (NumberFormatException e) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8303\u56f4\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                return;
            }
        }
        if (targetName != null) {
            List<Entity> targetEntities = BypassHelp.findEntitiesByName(player, targetName, range);
            if (!targetEntities.isEmpty()) {
                int removedCount = 0;
                String entityName = "";
                for (Entity entity : targetEntities) {
                    entityName = BypassHelp.getEntityDisplayName(entity);
                    switch (removeLevel) {
                        case 1: {
                            entity.m_142687_(Entity.RemovalReason.KILLED);
                            break;
                        }
                        case 2: {
                            entity.m_142687_(Entity.RemovalReason.DISCARDED);
                            break;
                        }
                        case 3: {
                            entity.m_146870_();
                            break;
                        }
                        default: {
                            entity.m_6074_();
                        }
                    }
                    ++removedCount;
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u79fb\u9664 " + entityName + " " + removedCount + "x")));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f53\uff01"));
            }
        } else {
            Entity targetEntity = BypassHelp.getTargetEntity(player, range);
            if (targetEntity != null) {
                String entityName = BypassHelp.getEntityDisplayName(targetEntity);
                switch (removeLevel) {
                    case 1: {
                        targetEntity.m_142687_(Entity.RemovalReason.KILLED);
                        break;
                    }
                    case 2: {
                        targetEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                        break;
                    }
                    case 3: {
                        targetEntity.m_146870_();
                        break;
                    }
                    default: {
                        targetEntity.m_6074_();
                    }
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u79fb\u9664 " + entityName + " 1x")));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f53\uff01"));
            }
        }
    }

    public static void handleGainCommand(ServerPlayer player, String[] parts) {
        if (parts.length < 2) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop gain <\u7269\u54c1\u540d\u79f0> [\u6570\u91cf] [\u73a9\u5bb6\u540d]"));
            return;
        }
        String itemName = parts[1];
        int amount = 1;
        ServerPlayer targetPlayer = player;
        if (parts.length > 2) {
            try {
                amount = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u6570\u91cf\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                return;
            }
        }
        if (parts.length > 3 && (targetPlayer = player.m_20194_().m_6846_().m_11255_(parts[3])) == null) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u627e\u4e0d\u5230\u73a9\u5bb6\uff1a" + parts[3])));
            return;
        }
        Item item = BypassHelp.getItemByName(itemName);
        if (item != null) {
            ItemStack itemStack = new ItemStack((ItemLike)item, amount);
            targetPlayer.m_150109_().m_36054_(itemStack);
            String displayName = BypassHelp.getItemDisplayName(item);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u6dfb\u52a0 [" + displayName + "] " + amount + "x")));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u4e0d\u5b58\u5728 " + itemName + " \u8be5\u7269\u54c1")));
        }
    }

    public static void handleOpLevelCommand(ServerPlayer player, String[] parts) {
        int opLevel;
        if (parts.length < 2) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop oplevel <\u7b49\u7ea7> [\u73a9\u5bb6\u540d]"));
            return;
        }
        try {
            opLevel = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cOP\u7b49\u7ea7\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
            return;
        }
        ServerPlayer targetPlayer = player;
        if (parts.length > 2 && (targetPlayer = player.m_20194_().m_6846_().m_11255_(parts[2])) == null) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u627e\u4e0d\u5230\u73a9\u5bb6\uff1a" + parts[2])));
            return;
        }
        player.m_20194_().m_6846_().m_5749_(targetPlayer.m_36316_());
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e " + targetPlayer.m_7755_().getString() + " \u7684OP\u7b49\u7ea7\u4e3a " + opLevel)));
    }

    public static Entity getTargetEntity(ServerPlayer player, double range) {
        Vec3 start = player.m_146892_();
        Vec3 end = start.m_82549_(player.m_20252_(1.0f).m_82490_(range));
        AABB searchBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - 1.0, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - 1.0, Math.max(start.f_82479_, end.f_82479_) + 1.0, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + 1.0);
        return player.m_9236_().m_45976_(Entity.class, searchBox).stream().filter(entity -> entity != player).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)player))).orElse(null);
    }

    public static void handleItemSetCommand(ServerPlayer player, String[] parts) {
        if (parts.length < 3) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop itemset <\u5c5e\u6027> <\u503c> [\u989d\u5916\u53c2\u6570]"));
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41619_()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8bf7\u5148\u624b\u6301\u4e00\u4e2a\u7269\u54c1\uff01"));
            return;
        }
        String property = parts[1].toLowerCase();
        String value = parts[2];
        switch (property) {
            case "stack": 
            case "count": {
                try {
                    int stackSize = Integer.parseInt(value);
                    heldItem.m_41764_(stackSize);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u5806\u53e0\u6570\u91cf\u4e3a\uff1a" + stackSize)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u5806\u53e0\u6570\u91cf\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "id": 
            case "item": {
                Item newItem = BypassHelp.getItemByName(value);
                if (newItem != null) {
                    int count = heldItem.m_41613_();
                    CompoundTag tag = heldItem.m_41783_();
                    ItemStack newStack = new ItemStack((ItemLike)newItem, count);
                    if (tag != null) {
                        newStack.m_41751_(tag.m_6426_());
                    }
                    player.m_21008_(InteractionHand.MAIN_HAND, newStack);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8f6c\u6362\u7269\u54c1\u4e3a\uff1a" + BypassHelp.getItemDisplayName(newItem))));
                    break;
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u672a\u627e\u5230\u7269\u54c1\uff1a" + value)));
                break;
            }
            case "damage": 
            case "attack": {
                try {
                    double damageValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.attack_damage", "Attack Damage", damageValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u653b\u51fb\u529b\u4e3a\uff1a" + damageValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u653b\u51fb\u529b\u6570\u503c\u65e0\u6548\uff01"));
                }
                break;
            }
            case "name": {
                String displayName = BypassHelp.combineArgs(parts, 2);
                displayName = BypassHelp.parseColorCodes(displayName);
                heldItem.m_41714_((Component)Component.m_237113_((String)displayName));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u8bbe\u7f6e\u7269\u54c1\u540d\u79f0"));
                break;
            }
            case "lore": {
                if (parts.length < 4) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop itemset lore <\u884c\u6570> <\u5185\u5bb9>"));
                    return;
                }
                try {
                    int lineNumber = Integer.parseInt(value);
                    String loreText = BypassHelp.combineArgs(parts, 3);
                    loreText = BypassHelp.parseColorCodes(loreText);
                    CompoundTag tag = heldItem.m_41784_();
                    CompoundTag display = tag.m_128469_("display");
                    ListTag lore = display.m_128437_("Lore", 8);
                    while (lore.size() < lineNumber) {
                        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)""))));
                    }
                    lore.set(lineNumber - 1, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)loreText))));
                    display.m_128365_("Lore", (Tag)lore);
                    tag.m_128365_("display", (Tag)display);
                    heldItem.m_41751_(tag);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u7b2c" + lineNumber + "\u884c\u63cf\u8ff0")));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u884c\u6570\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "enc": 
            case "enchant": {
                if (parts.length < 4) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop itemset enc <\u9644\u9b54\u540d> <\u7b49\u7ea7>"));
                    return;
                }
                String enchantName = parts[2];
                try {
                    int level = Integer.parseInt(parts[3]);
                    Enchantment enchantment = BypassHelp.getEnchantmentByName(enchantName);
                    if (enchantment != null) {
                        CompoundTag tag = heldItem.m_41784_();
                        ListTag enchantments = tag.m_128437_("Enchantments", 10);
                        enchantments.removeIf(enchTag -> {
                            CompoundTag compound = (CompoundTag)enchTag;
                            return compound.m_128461_("id").equals(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment).toString());
                        });
                        CompoundTag enchantTag = new CompoundTag();
                        enchantTag.m_128359_("id", BuiltInRegistries.f_256876_.m_7981_((Object)enchantment).toString());
                        enchantTag.m_128405_("lvl", level);
                        enchantments.add((Object)enchantTag);
                        tag.m_128365_("Enchantments", (Tag)enchantments);
                        heldItem.m_41751_(tag);
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u6dfb\u52a0\u9644\u9b54\uff1a" + BypassHelp.getEnchantmentDisplayName(enchantment) + " " + level)));
                        break;
                    }
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u672a\u627e\u5230\u9644\u9b54\uff1a" + enchantName)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u9644\u9b54\u7b49\u7ea7\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "unbreakable": {
                boolean unbreakable = value.equalsIgnoreCase("true") || value.equals("1");
                CompoundTag unbreakableTag = heldItem.m_41784_();
                unbreakableTag.m_128379_("Unbreakable", unbreakable);
                heldItem.m_41751_(unbreakableTag);
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u65e0\u635f\u574f\uff1a" + unbreakable)));
                break;
            }
            case "durability": 
            case "damage_value": {
                try {
                    int durability = Integer.parseInt(value);
                    heldItem.m_41721_(durability);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u8010\u4e45\u635f\u4f24\u4e3a\uff1a" + durability)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8010\u4e45\u503c\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "speed": 
            case "attack_speed": {
                try {
                    double speedValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.attack_speed", "Attack Speed", speedValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u653b\u51fb\u901f\u5ea6\u4e3a\uff1a" + speedValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u653b\u51fb\u901f\u5ea6\u6570\u503c\u65e0\u6548\uff01"));
                }
                break;
            }
            case "nbt": {
                try {
                    String nbtString = BypassHelp.combineArgs(parts, 2);
                    CompoundTag newTag = TagParser.m_129359_((String)nbtString);
                    CompoundTag currentTag = heldItem.m_41784_();
                    currentTag.m_128391_(newTag);
                    heldItem.m_41751_(currentTag);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u6dfb\u52a0NBT\u6570\u636e"));
                }
                catch (Exception e) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7cNBT\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage())));
                }
                break;
            }
            case "armor": {
                try {
                    double armorValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.armor", "Armor", armorValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u62a4\u7532\u503c\u4e3a\uff1a" + armorValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u62a4\u7532\u503c\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "armor_toughness": 
            case "toughness": {
                try {
                    double toughnessValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.armor_toughness", "Armor Toughness", toughnessValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u62a4\u7532\u97e7\u6027\u4e3a\uff1a" + toughnessValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u62a4\u7532\u97e7\u6027\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "knockback": 
            case "knockback_resistance": {
                try {
                    double knockbackValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.knockback_resistance", "Knockback Resistance", knockbackValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u51fb\u9000\u6297\u6027\u4e3a\uff1a" + knockbackValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u51fb\u9000\u6297\u6027\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "movement_speed": 
            case "move_speed": {
                try {
                    double speedValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.movement_speed", "Movement Speed", speedValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u79fb\u52a8\u901f\u5ea6\u4e3a\uff1a" + speedValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u79fb\u52a8\u901f\u5ea6\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "luck": {
                try {
                    double luckValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.luck", "Luck", luckValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u5e78\u8fd0\u503c\u4e3a\uff1a" + luckValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u5e78\u8fd0\u503c\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "max_health": 
            case "health": {
                try {
                    double healthValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.max_health", "Max Health", healthValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u6700\u5927\u751f\u547d\u503c\u4e3a\uff1a" + healthValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u751f\u547d\u503c\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "reach": 
            case "reach_distance": {
                try {
                    double reachValue = Double.parseDouble(value);
                    BypassHelp.addOrUpdateAttribute(heldItem, "generic.attack_reach", "Attack Reach", reachValue, "mainhand");
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u653b\u51fb\u8ddd\u79bb\u4e3a\uff1a" + reachValue)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u653b\u51fb\u8ddd\u79bb\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "repair_cost": {
                try {
                    int repairCost = Integer.parseInt(value);
                    CompoundTag tag = heldItem.m_41784_();
                    tag.m_128405_("RepairCost", repairCost);
                    heldItem.m_41751_(tag);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u4fee\u590d\u8d39\u7528\u4e3a\uff1a" + repairCost)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4fee\u590d\u8d39\u7528\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "hide_flags": 
            case "hideflags": {
                try {
                    int hideFlags = Integer.parseInt(value);
                    CompoundTag tag = heldItem.m_41784_();
                    tag.m_128405_("HideFlags", hideFlags);
                    heldItem.m_41751_(tag);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u9690\u85cf\u6807\u5fd7\u4e3a\uff1a" + hideFlags)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u9690\u85cf\u6807\u5fd7\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "custom_model_data": 
            case "cmd": {
                try {
                    int customModelData = Integer.parseInt(value);
                    CompoundTag tag = heldItem.m_41784_();
                    tag.m_128405_("CustomModelData", customModelData);
                    heldItem.m_41751_(tag);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u6a21\u578b\u6570\u636e\u4e3a\uff1a" + customModelData)));
                }
                catch (NumberFormatException e) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u81ea\u5b9a\u4e49\u6a21\u578b\u6570\u636e\u5fc5\u987b\u662f\u6570\u5b57\uff01"));
                }
                break;
            }
            case "clear_enchants": {
                CompoundTag tag = heldItem.m_41784_();
                tag.m_128473_("Enchantments");
                heldItem.m_41751_(tag);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u6e05\u9664\u6240\u6709\u9644\u9b54"));
                break;
            }
            case "clear_attributes": {
                CompoundTag attrTag = heldItem.m_41784_();
                attrTag.m_128473_("AttributeModifiers");
                heldItem.m_41751_(attrTag);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u6e05\u9664\u6240\u6709\u5c5e\u6027\u4fee\u9970\u7b26"));
                break;
            }
            case "clear_lore": {
                CompoundTag loreTag = heldItem.m_41784_();
                CompoundTag display = loreTag.m_128469_("display");
                display.m_128473_("Lore");
                loreTag.m_128365_("display", (Tag)display);
                heldItem.m_41751_(loreTag);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6210\u529f\u6e05\u9664\u6240\u6709\u63cf\u8ff0"));
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u672a\u77e5\u5c5e\u6027\uff1a" + property)));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u53ef\u7528\u5c5e\u6027\uff1a"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u57fa\u7840: stack, id, damage, name, lore, durability, unbreakable"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u9644\u9b54: enc, clear_enchants"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u5c5e\u6027: speed, armor, toughness, knockback, movement_speed, luck, health, reach"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u9ad8\u7ea7: nbt, repair_cost, hide_flags, custom_model_data"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u6e05\u7406: clear_attributes, clear_lore"));
            }
        }
    }

    public static void addOrUpdateAttribute(ItemStack item, String attributeName, String displayName, double value, String slot) {
        CompoundTag tag = item.m_41784_();
        ListTag modifiers = tag.m_128437_("AttributeModifiers", 10);
        modifiers.removeIf(modifier -> {
            CompoundTag compound = (CompoundTag)modifier;
            return compound.m_128461_("AttributeName").equals(attributeName);
        });
        CompoundTag attributeModifier = new CompoundTag();
        attributeModifier.m_128359_("AttributeName", attributeName);
        attributeModifier.m_128359_("Name", displayName);
        attributeModifier.m_128347_("Amount", value);
        attributeModifier.m_128405_("Operation", 0);
        attributeModifier.m_128359_("Slot", slot);
        attributeModifier.m_128385_("UUID", new int[]{(int)(Math.random() * 2.147483647E9), (int)(Math.random() * 2.147483647E9), (int)(Math.random() * 2.147483647E9), (int)(Math.random() * 2.147483647E9)});
        modifiers.add((Object)attributeModifier);
        tag.m_128365_("AttributeModifiers", (Tag)modifiers);
        item.m_41751_(tag);
    }

    public static String combineArgs(String[] parts, int startIndex) {
        StringBuilder builder = new StringBuilder();
        for (int i = startIndex; i < parts.length; ++i) {
            if (i > startIndex) {
                builder.append(" ");
            }
            builder.append(parts[i]);
        }
        return builder.toString();
    }

    public static String parseColorCodes(String text) {
        text = text.replace('&', '\u00a7');
        return text;
    }

    public static Enchantment getEnchantmentByName(String name) {
        Map<String, String> chineseEnchantments = Map.of("\u950b\u5229", "sharpness", "\u4fdd\u62a4", "protection", "\u6548\u7387", "efficiency", "\u8010\u4e45", "unbreaking", "\u7ecf\u9a8c\u4fee\u8865", "mending", "\u706b\u7130\u9644\u52a0", "fire_aspect", "\u62a2\u593a", "looting", "\u51fb\u9000", "knockback", "\u529b\u91cf", "power", "\u51b2\u51fb", "punch");
        String enchantmentId = chineseEnchantments.getOrDefault(name.toLowerCase(), name.toLowerCase());
        if (enchantmentId.contains(":")) {
            try {
                ResourceLocation location = new ResourceLocation(enchantmentId);
                return (Enchantment)BuiltInRegistries.f_256876_.m_7745_(location);
            }
            catch (Exception location) {
                // empty catch block
            }
        }
        try {
            ResourceLocation minecraftLocation = new ResourceLocation("minecraft", enchantmentId);
            if (BuiltInRegistries.f_256876_.m_7804_(minecraftLocation)) {
                return (Enchantment)BuiltInRegistries.f_256876_.m_7745_(minecraftLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BuiltInRegistries.f_256876_.m_123024_().filter(enchantment -> {
            String displayName = Component.m_237115_((String)enchantment.m_44704_()).getString();
            return displayName.contains(name) || displayName.toLowerCase().contains(name.toLowerCase());
        }).findFirst().orElse(null);
    }

    public static String getEnchantmentDisplayName(Enchantment enchantment) {
        return Component.m_237115_((String)enchantment.m_44704_()).getString();
    }

    public static void handleSetCommand(ServerPlayer player, String[] parts) {
        if (parts.length < 4) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u7528\u6cd5\uff1a\\bypassop set <\u76ee\u6807> <\u5c5e\u6027> <\u503c>"));
            return;
        }
        String targetName = parts[1];
        String attributeName = parts[2].toLowerCase();
        String value = parts[3];
        Entity targetEntity = null;
        if (targetName.equals("target")) {
            targetEntity = BypassHelp.getTargetEntity(player, 10.0);
        } else {
            ServerPlayer targetPlayer = player.m_20194_().m_6846_().m_11255_(targetName);
            if (targetPlayer != null) {
                targetEntity = targetPlayer;
            }
        }
        if (targetEntity == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f53\uff01"));
            return;
        }
        if (value.equals("un")) {
            BypassHelp.resetEntityAttribute(targetEntity, attributeName);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u91cd\u7f6e " + BypassHelp.getEntityDisplayName(targetEntity) + " \u7684 " + attributeName + " \u5c5e\u6027")));
        } else {
            boolean success = BypassHelp.setEntityAttribute(targetEntity, attributeName, value);
            if (success) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u6210\u529f\u8bbe\u7f6e " + BypassHelp.getEntityDisplayName(targetEntity) + " \u7684 " + attributeName + " \u4e3a " + value)));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25\uff01"));
            }
        }
    }
}

