/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Content.Workbenchs;

import com.baizeli.eternisstarrysky.Content.Workbenchs.ModBlockEntities;
import com.baizeli.eternisstarrysky.Content.Workbenchs.ModRecipeTypes;
import com.baizeli.eternisstarrysky.Content.Workbenchs.VanillaWorkbenchMenu;
import com.baizeli.eternisstarrysky.Content.Workbenchs.VanillaWorkbenchRecipe;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class VanillaWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider {
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ItemStackHandler itemHandler = new ItemStackHandler(82){

        protected void onContentsChanged(int slot) {
            VanillaWorkbenchBlockEntity.this.m_6596_();
            if (slot < 81) {
                VanillaWorkbenchBlockEntity.this.updateRecipe();
            }
        }
    };

    public Component m_5446_() {
        return Component.m_237115_((String)"container.eternisstarrysky.vanilla_workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new VanillaWorkbenchMenu(windowId, playerInventory, this, this.f_58858_);
    }

    public VanillaWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.VANILLA_WORKBENCH.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void updateRecipe() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        SimpleContainer container = new SimpleContainer(81);
        for (int i = 0; i < 81; ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.VANILLA_WORKBENCH_TYPE.get(), (Container)container, this.f_58857_);
        if (recipe.isPresent()) {
            ItemStack result = ((VanillaWorkbenchRecipe)recipe.get()).m_5874_((Container)container, this.f_58857_.m_9598_());
            this.itemHandler.setStackInSlot(81, result);
        } else {
            this.itemHandler.setStackInSlot(81, ItemStack.f_41583_);
        }
    }

    public void onResultTaken(Player player, ItemStack result) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        SimpleContainer container = new SimpleContainer(81);
        for (int i = 0; i < 81; ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.VANILLA_WORKBENCH_TYPE.get(), (Container)container, this.f_58857_);
        if (recipe.isPresent()) {
            for (int i = 0; i < 81; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                stack.m_41774_(1);
                this.itemHandler.setStackInSlot(i, stack);
            }
            this.updateRecipe();
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public Optional<VanillaWorkbenchRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots() - 1);
        for (int i = 0; i < container.m_6643_(); ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.VANILLA_WORKBENCH_TYPE.get(), (Container)container, this.f_58857_);
    }

    private boolean matchesShapedAt(VanillaWorkbenchRecipe recipe, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                ItemStack stack;
                int recipeX = x - startX;
                int recipeY = y - startY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (recipeX >= 0 && recipeY >= 0 && recipeX < recipe.width && recipeY < recipe.height) {
                    ingredient = mirrored ? (Ingredient)recipe.m_7527_().get(recipe.width - recipeX - 1 + recipeY * recipe.width) : (Ingredient)recipe.m_7527_().get(recipeX + recipeY * recipe.width);
                }
                if (ingredient.test(stack = this.itemHandler.getStackInSlot(x + y * 9))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchesShapedRecipe(VanillaWorkbenchRecipe recipe) {
        for (int i = 0; i <= 9 - recipe.width; ++i) {
            for (int j = 0; j <= 9 - recipe.height; ++j) {
                if (!this.matchesShapedAt(recipe, i, j, false) && !this.matchesShapedAt(recipe, i, j, true)) continue;
                return true;
            }
        }
        return false;
    }

    public void consumeIngredientsForResult(Player player, ItemStack result) {
        Optional<VanillaWorkbenchRecipe> recipeOpt = this.getCurrentRecipe();
        if (recipeOpt.isPresent()) {
            VanillaWorkbenchRecipe recipe = recipeOpt.get();
            if (recipe.shaped) {
                this.consumeShapedIngredients(recipe);
            } else {
                this.consumeShapelessIngredients(recipe);
            }
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    private void consumeShapedIngredients(VanillaWorkbenchRecipe recipe) {
        for (int i = 0; i <= 9 - recipe.width; ++i) {
            for (int j = 0; j <= 9 - recipe.height; ++j) {
                boolean normalMatch = this.matchesShapedAt(recipe, i, j, false);
                boolean mirroredMatch = this.matchesShapedAt(recipe, i, j, true);
                if (!normalMatch && !mirroredMatch) continue;
                this.consumeAtPosition(recipe, i, j, mirroredMatch);
                return;
            }
        }
    }

    private void consumeShapelessIngredients(VanillaWorkbenchRecipe recipe) {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(recipe.m_7527_());
        block0: for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            for (int j = 0; j < ingredients.size(); ++j) {
                if (!((Ingredient)ingredients.get(j)).test(stack)) continue;
                this.itemHandler.extractItem(i, 1, false);
                ingredients.remove(j);
                continue block0;
            }
        }
    }

    private void consumeAtPosition(VanillaWorkbenchRecipe recipe, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                Ingredient ingredient;
                int recipeX = x - startX;
                int recipeY = y - startY;
                if (recipeX < 0 || recipeY < 0 || recipeX >= recipe.width || recipeY >= recipe.height || (ingredient = mirrored ? (Ingredient)recipe.m_7527_().get(recipe.width - recipeX - 1 + recipeY * recipe.width) : (Ingredient)recipe.m_7527_().get(recipeX + recipeY * recipe.width)).m_43947_()) continue;
                int slotIndex = x + y * 9;
                this.itemHandler.extractItem(slotIndex, 1, false);
            }
        }
    }
}

