/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Entity;

import com.baizeli.eternisstarrysky.Entity.BossMusic;
import com.google.common.base.Suppliers;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossEntity
extends Monster {
    public final BossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private transient Supplier<BossMusic> clientBossMusicInstance;
    private boolean musicStarted = false;

    public BossEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_6457_(ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
    }

    public void m_6452_(ServerPlayer pServerPlayer) {
        super.m_6452_(pServerPlayer);
    }

    public ResourceLocation getBossBarOverlay() {
        return null;
    }

    public Font getBossBarFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    @Nullable
    public SoundEvent getBossMusic() {
        return null;
    }

    public boolean m_21532_() {
        return true;
    }

    public float getMaxDamageHurt() {
        return Float.MAX_VALUE;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        return super.m_7327_(pEntity);
    }

    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.WHITE;
    }

    public boolean m_147207_(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        return false;
    }

    public boolean m_7292_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public void m_147215_(MobEffectInstance pInstance, @Nullable Entity pEntity) {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        ServerPlayer player;
        LivingEntity living;
        if (BossEntity.isUnsafeDamage(pSource)) {
            return false;
        }
        this.m_20256_(Vec3.f_82478_);
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof BossEntity) && !(living instanceof Player)) {
            this.m_6710_(living);
        }
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_7500_()) {
            this.m_6710_((LivingEntity)player);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public static boolean isUnsafeDamage(DamageSource d) {
        return d.m_276093_(DamageTypes.f_268433_) || d.m_276093_(DamageTypes.f_286979_) || d.m_276093_(DamageTypes.f_268724_) || d.m_276093_(DamageTypes.f_268739_) || d.m_276093_(DamageTypes.f_268493_) || d.m_276093_(DamageTypes.f_268641_) || d.m_276093_(DamageTypes.f_268565_) || d.m_276093_(DamageTypes.f_268515_);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    public void m_21153_(float pHealth) {
        if (pHealth < this.m_21223_() - this.getMaxDamageHurt()) {
            pHealth = this.m_21223_() - this.getMaxDamageHurt();
        }
        super.m_21153_(pHealth);
    }

    public void m_6074_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_6456_(this.m_5446_());
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        this.m_183634_();
        if (this.m_21223_() > 0.0f) {
            this.f_20919_ = 0;
        }
        if (this.m_9236_().m_5776_()) {
            this.handleBossMusic();
        }
    }

    private void handleBossMusic() {
        Minecraft mc = Minecraft.m_91087_();
        float musicVolume = mc.f_91066_.m_92147_(SoundSource.MUSIC);
        if (this.m_6084_() && musicVolume > 0.0f) {
            if (!this.musicStarted || this.clientBossMusicInstance == null || this.clientBossMusicInstance.get().m_7801_()) {
                this.clientBossMusicInstance = Suppliers.ofInstance((Object)((Object)BossMusic.create(this)));
            }
            if (this.clientBossMusicInstance.get() != null && !mc.m_91106_().m_120403_((SoundInstance)this.clientBossMusicInstance.get())) {
                mc.m_91106_().m_120367_((SoundInstance)this.clientBossMusicInstance.get());
                this.musicStarted = true;
            }
        } else if (this.musicStarted) {
            this.stopBossMusic();
        }
    }

    private void stopBossMusic() {
        if (this.clientBossMusicInstance != null) {
            this.clientBossMusicInstance.get().setShouldStop();
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.clientBossMusicInstance.get());
        }
        this.musicStarted = false;
        this.clientBossMusicInstance = null;
    }

    public void m_6667_(@NotNull DamageSource pSource) {
        if (this.m_21224_()) {
            super.m_6667_(pSource);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (this.m_21224_()) {
            super.m_142687_(reason);
        }
    }

    public boolean m_21224_() {
        return this.m_21223_() <= 0.0f;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6842_(boolean invisible) {
    }

    public boolean m_20145_() {
        return false;
    }

    public boolean m_21525_() {
        return false;
    }

    public void m_21557_(boolean noAi) {
    }

    public void updateFluidHeightAndDoFluidPushing(Predicate<FluidState> shouldUpdate) {
    }

    public void m_8097_() {
        super.m_8097_();
    }
}

