/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Entity;

import com.baizeli.eternisstarrysky.Entity.BossEntity;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class BossMusic
extends AbstractTickableSoundInstance {
    BossEntity boss;
    private final float baseVolume;
    private static Float originalMusicVolume = null;
    private boolean shouldStop = false;

    protected BossMusic(BossEntity boss) {
        super(boss.getBossMusic(), SoundSource.MUSIC, RandomSource.m_216327_());
        this.boss = boss;
        this.f_119574_ = 1.0f;
        this.f_119578_ = true;
        this.f_119573_ = this.baseVolume = 0.5f;
        if (originalMusicVolume == null) {
            originalMusicVolume = Float.valueOf(Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC));
            try {
                Method method = Minecraft.m_91087_().f_91066_.getClass().getDeclaredMethod("setSoundCategoryVolume", SoundSource.class, Float.TYPE);
                method.setAccessible(true);
                method.invoke((Object)Minecraft.m_91087_().f_91066_, SoundSource.MUSIC, Float.valueOf(0.0f));
                Minecraft.m_91087_().f_91066_.m_92169_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public static BossMusic create(BossEntity boss) {
        if (boss == null || boss.getBossMusic() == null) {
            return null;
        }
        return new BossMusic(boss);
    }

    public void m_7788_() {
        if (this.boss == null || !this.boss.m_6084_() || Minecraft.m_91087_().f_91074_ == null || this.shouldStop) {
            this.stopMusic();
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC) <= 0.0f) {
            this.f_119573_ = 0.0f;
            return;
        }
        float maxDistance = 60.0f;
        float distance = this.boss.m_20270_((Entity)Minecraft.m_91087_().f_91074_);
        float playerMusicVolumeSetting = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC);
        if (distance > maxDistance) {
            this.f_119573_ = 0.0f;
        } else if (distance < 5.0f) {
            this.f_119573_ = this.baseVolume * playerMusicVolumeSetting;
        } else {
            float distanceFactor = 1.0f - Math.max(0.0f, distance - 5.0f) / (maxDistance - 5.0f);
            this.f_119573_ = this.baseVolume * distanceFactor * playerMusicVolumeSetting;
        }
        this.f_119573_ = Mth.m_14036_((float)this.f_119573_, (float)0.0f, (float)1.0f);
        this.f_119575_ = this.boss.m_20185_();
        this.f_119576_ = this.boss.m_20186_();
        this.f_119577_ = this.boss.m_20189_();
    }

    public boolean canPlayMusic() {
        boolean b = true;
        try {
            SoundEngine soundEngine = Minecraft.m_91087_().m_91106_().f_120349_;
            for (SoundInstance soundInstance : soundEngine.f_120228_) {
                if (!soundInstance.m_7904_().equals((Object)this.m_7904_()) || !(soundInstance.m_7769_() > 0.0f)) continue;
                b = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this) && Minecraft.m_91087_().f_91073_.m_5776_() && b;
    }

    public void stopMusic() {
        super.m_119609_();
        BossMusic.restoreMusicVolume();
    }

    public boolean m_7801_() {
        if (super.m_7801_() || this.shouldStop) {
            BossMusic.restoreMusicVolume();
            return true;
        }
        return false;
    }

    public void setShouldStop() {
        this.shouldStop = true;
    }

    private static void restoreMusicVolume() {
        if (originalMusicVolume != null) {
            try {
                Method method = Minecraft.m_91087_().f_91066_.getClass().getDeclaredMethod("setSoundCategoryVolume", SoundSource.class, Float.TYPE);
                method.setAccessible(true);
                method.invoke((Object)Minecraft.m_91087_().f_91066_, SoundSource.MUSIC, originalMusicVolume);
                Minecraft.m_91087_().f_91066_.m_92169_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            originalMusicVolume = null;
        }
    }

    public static void playMusic(BossMusic music, BossEntity bossEntity) {
        if (Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC) <= 0.0f) {
            music = null;
        }
        if (music != null) {
            music = new BossMusic(bossEntity);
        }
        if (music != null && music.canPlayMusic()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)music);
        }
    }

    public float m_7769_() {
        return this.f_119573_;
    }
}

