/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Entity;

import com.baizeli.eternisstarrysky.Entity.BossEntity;
import com.baizeli.eternisstarrysky.Entity.CsdyMeleeGoal;
import com.baizeli.eternisstarrysky.Entity.PersistentHurtByTargetGoal;
import com.baizeli.eternisstarrysky.SoundsRegister;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwordManCsdy
extends BossEntity
implements GeoEntity {
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.model.stand");
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.model.walk");
    private CsdyMeleeGoal meleeGoal;
    private int attackBehaviorCooldown = 0;
    private AnimationController<SwordManCsdy> mainAnimationController;
    private transient Object clientBossMusicInstance;
    private boolean musicStarted = false;
    public boolean isDead;
    private float oldHealth;
    private float lastHealth;
    private int updateTimer;
    private Entity.RemovalReason oldRemovalReason;
    private boolean damageTooHigh;
    private static final EntityDataAccessor<Float> DATA_HEALTH_ID = SwordManCsdy.getHealthDataAccessor();
    private final ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING = SynchedEntityData.m_135353_(SwordManCsdy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_REAL = SynchedEntityData.m_135353_(SwordManCsdy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("eternisstarrysky", "entities/sword_man_csdy");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (name != null && name.getString().contains("\u6c89\u7761\u7684\u827a") && !this.isReal()) {
            this.m_21153_(this.m_21233_());
            this.setReal(true);
        }
    }

    private static EntityDataAccessor<Float> getHealthDataAccessor() {
        for (String fieldName : new String[]{"DATA_HEALTH_ID", "f_20961_", "health"}) {
            try {
                Field field = LivingEntity.class.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(null);
                if (!(value instanceof EntityDataAccessor)) continue;
                return (EntityDataAccessor)value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public SwordManCsdy(EntityType<? extends BossEntity> type, Level level) {
        super(type, level);
        this.f_19804_.m_135381_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21233_()));
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21530_();
        this.oldHealth = this.m_21223_();
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_REAL, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(DATA_IS_ATTACKING, (Object)attacking);
    }

    public boolean isReal() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_REAL);
    }

    public void setReal(boolean real) {
        this.f_19804_.m_135381_(DATA_IS_REAL, (Object)real);
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return LOOT_TABLE;
    }

    @Override
    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    @Override
    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.bossEvent != null) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            serverLevel.m_8606_(0, 400, true, true);
        }
        this.f_19802_ = 0;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.bossEvent.m_7706_();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundsRegister.GIRL_A.get();
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float damage) {
        if (this.isReal()) {
            return false;
        }
        float sqrtDamage = (float)Math.sqrt(damage);
        float realDamage = sqrtDamage * 0.2f;
        if (realDamage < 100.0f) {
            return false;
        }
        this.teleportToAttacker(source);
        return super.m_6469_(source, realDamage);
    }

    private void teleportToAttacker(DamageSource source) {
        Entity attacker = source.m_7639_();
        if (attacker == null || attacker == this) {
            return;
        }
        double x = attacker.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 1.2;
        double y = attacker.m_20186_() + (double)this.f_19796_.m_188503_(2);
        double z = attacker.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 1.2;
        this.m_6021_(x, y, z);
    }

    @Override
    public void m_21153_(float value) {
        float threshold;
        if (this.isReal()) {
            return;
        }
        float currentHealth = this.m_21223_();
        float healthLoss = currentHealth - value;
        float processedHealthLoss = (float)(Math.sqrt(healthLoss) * (double)0.2f);
        if (processedHealthLoss > (threshold = 325.0f)) {
            value = currentHealth - processedHealthLoss * 0.2f;
        }
        super.m_21153_(value);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new CsdyMeleeGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new PersistentHurtByTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::mainAnimController)});
    }

    private PlayState mainAnimController(AnimationState<SwordManCsdy> state) {
        if (state.isMoving() || this.m_5448_() != null || this.isAttacking()) {
            return state.setAndContinue(WALK_ANIM);
        }
        return state.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 4.4);
        builder = builder.m_22268_(Attributes.f_22276_, 10000.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1600.0);
        builder = builder.m_22268_(Attributes.f_22283_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }
}

