/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Items;

import com.baizeli.Sounds;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InfinitySword
extends SwordItem {
    private static final double KILL_RADIUS = 5.0;

    public InfinitySword(Tier p_43269_, int p_43270_, float p_43271_, Item.Properties p_43272_) {
        super(p_43269_, p_43270_, p_43271_, p_43272_);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!(player instanceof ServerPlayer)) {
            Sounds.play(SoundEvents.f_144049_, player, 10.0f, 1.0f);
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (((LivingEntity)entity).m_21224_()) {
            return false;
        }
        float strength = player.m_36403_(0.5f);
        List<LivingEntity> nearbyEntities = List.of((LivingEntity)entity);
        if ((double)strength >= 1.0) {
            Predicate<LivingEntity> predicate = e -> e.m_19879_() != player.m_19879_();
            nearbyEntities = InfinitySword.getNearbyLivingEntities(entity, 5.0, predicate);
        }
        DamageSource source = new DamageSource(player.m_269291_().m_269341_().m_269150_(), (Entity)player);
        nearbyEntities.forEach(living -> {
            player.m_5704_((Entity)living);
            living.m_6469_(source, this.m_43299_() * strength);
        });
        InfinitySword.sweep(player, entity, stack, this.m_43299_());
        player.m_36334_();
        return true;
    }

    public static List<LivingEntity> getNearbyLivingEntities(Entity entity, double radius, Predicate<LivingEntity> predicate) {
        Level level;
        block5: {
            block4: {
                if (entity == null) break block4;
                level = entity.m_9236_();
                if (!level.f_46443_) break block5;
            }
            return List.of();
        }
        EntityTypeTest typeTest = EntityTypeTest.m_156916_(LivingEntity.class);
        Vec3 pos = entity.m_20182_();
        AABB aabb = new AABB(pos.f_82479_ - radius, pos.f_82480_ - radius, pos.f_82481_ - radius, pos.f_82479_ + radius, pos.f_82480_ + radius, pos.f_82481_ + radius);
        LinkedList<LivingEntity> nearbyEntities = new LinkedList<LivingEntity>();
        if (predicate == null) {
            predicate = e -> true;
        }
        level.m_260826_(typeTest, aabb, predicate, nearbyEntities, Integer.MAX_VALUE);
        return nearbyEntities;
    }

    public static void sweep(Player player, Entity target, ItemStack item, double damage) {
        boolean sweep;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        float strength = player.m_36403_(0.5f);
        boolean cooldown = (double)strength >= 1.0;
        boolean sprinting = cooldown && player.m_20142_();
        boolean crit = cooldown && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && !sprinting;
        double d0 = player.f_19787_ - player.f_19867_;
        boolean bl = sweep = cooldown && !sprinting && !crit && player.m_20096_() && d0 < (double)player.m_6113_();
        if (!sweep) {
            return;
        }
        int sweepLevel = item.getEnchantmentLevel(Enchantments.f_44983_) + 2;
        double sweepDamage = (1.0 - 1.0 / (double)sweepLevel) * damage;
        AABB sweepHitBox = player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, target);
        for (LivingEntity living : player.m_9236_().m_45976_(LivingEntity.class, sweepHitBox)) {
            double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
            boolean flag = living != player;
            flag &= living != target;
            flag &= !player.m_7307_((Entity)living);
            flag &= !(living instanceof ArmorStand) || !((ArmorStand)living).m_31677_();
            if (!(flag &= player.m_20280_((Entity)living) < entityReachSq)) continue;
            double ratioX = Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double ratioZ = -Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            living.m_147240_(0.4, ratioX, ratioZ);
            living.m_6469_(player.m_269291_().m_269341_(), (float)sweepDamage);
        }
        SoundEvent sound = SoundEvents.f_12317_;
        SoundSource source = player.m_5720_();
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, source, 1.0f, 1.0f);
        player.m_36346_();
    }
}

