/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Items;

import com.baizeli.Sounds;
import com.baizeli.eternisstarrysky.EntityMarker;
import com.baizeli.eternisstarrysky.Items.InfinitySword;
import com.baizeli.eternisstarrysky.RainbowEffectHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class InfinitySwordTrue
extends SwordItem {
    private static final double KILL_RADIUS = 5.0;
    Font font = null;

    public InfinitySwordTrue(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties.m_41497_(Rarity.EPIC).m_41486_());
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        stack.m_41784_().m_128405_("HideFlags", 2);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!stack.m_41784_().m_128441_("HideFlags")) {
            stack.m_41784_().m_128405_("HideFlags", 2);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity2, int timeLeft) {
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        if (!(entity2 instanceof ServerPlayer)) {
            Sounds.play(SoundEvents.f_11983_, player, 1.0f, 0.8f);
        }
        if (entity2 instanceof Player) {
            AABB searchArea;
            double radius;
            Vec3 playerPos;
            if (!level.f_46443_) {
                playerPos = player.m_20182_();
                radius = 17.0;
                searchArea = new AABB(playerPos.f_82479_ - radius, playerPos.f_82480_ - radius, playerPos.f_82481_ - radius, playerPos.f_82479_ + radius, playerPos.f_82480_ + radius, playerPos.f_82481_ + radius);
                List nearbyEntities = level.m_6443_(LivingEntity.class, searchArea, entity -> entity != null && entity != player && (double)entity.m_20270_((Entity)player) <= radius && !(entity instanceof Player));
                nearbyEntities.sort((e1, e2) -> Float.compare(e1.m_20270_((Entity)player), e2.m_20270_((Entity)player)));
                List targetsToKill = nearbyEntities.subList(0, Math.min(9, nearbyEntities.size()));
                for (int i = 0; i < 50; ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
                    double offsetY = (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, playerPos.f_82479_ + offsetX, playerPos.f_82480_ + offsetY, playerPos.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, playerPos.f_82479_ + offsetX, playerPos.f_82480_ + offsetY, playerPos.f_82481_ + offsetZ, 0.0, 0.1, 0.0);
                }
                if (targetsToKill instanceof ArmorStand) {
                    return;
                }
                if (targetsToKill instanceof ItemFrame) {
                    return;
                }
                if (targetsToKill instanceof Painting) {
                    return;
                }
                for (LivingEntity entity3 : targetsToKill) {
                    if (!(entity3 instanceof Monster) && !(entity3 instanceof Player)) {
                        return;
                    }
                    if (!entity3.m_6084_() || entity3 == player) continue;
                    entity3.m_21219_();
                    entity3.f_19802_ = 0;
                    entity3.f_20916_ = 0;
                    DamageSource void_damage = new DamageSource(entity3.m_269291_().m_269341_().m_269150_(), (Entity)player);
                    entity3.m_6469_(void_damage, Float.MAX_VALUE);
                    entity3.m_21153_(0.0f);
                    entity3.m_6074_();
                    entity3.m_142687_(Entity.RemovalReason.KILLED);
                    ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)entity3.m_9236_()), (Vec3)entity3.m_20182_(), (int)entity3.m_213860_());
                    entity3.m_7472_(entity3.m_269291_().m_269075_(player), 10, true);
                    entity3.m_7625_(entity3.m_269291_().m_269075_(player), true);
                    for (int i = 0; i < 10; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, entity3.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 2.0, entity3.m_20186_() + level.f_46441_.m_188500_() * 2.0, entity3.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 2.0, 0.0, 0.1, 0.0);
                    }
                }
                if (!targetsToKill.isEmpty()) {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11860_, SoundSource.PLAYERS, 1.0f, 0.1f);
                }
            }
            playerPos = player.m_20182_();
            radius = 20.0;
            searchArea = new AABB(playerPos.f_82479_ - radius, playerPos.f_82480_ - radius, playerPos.f_82481_ - radius, playerPos.f_82479_ + radius, playerPos.f_82480_ + radius, playerPos.f_82481_ + radius);
            List itemEntities = level.m_45976_(ItemEntity.class, searchArea);
            int itemCount = 0;
            for (ItemEntity itemEntity : itemEntities) {
                double distance = itemEntity.m_20182_().m_82554_(playerPos);
                if (!(distance <= radius)) continue;
                if (player.m_150109_().m_36062_() > 0) {
                    player.m_36356_(itemEntity.m_32055_());
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                ++itemCount;
            }
            if (!level.f_46443_ && itemCount > 0) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a76\u5438\u53d6\u4e86 \u00a7e" + itemCount + " \u00a76\u4e2a\u6389\u843d\u7269\uff01")), true);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        Component originalName = super.m_7626_(stack);
        if (stack.m_41788_()) {
            return originalName;
        }
        stack.m_41784_().m_128405_("HideFlags", 2);
        return originalName;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!(player instanceof ServerPlayer)) {
            Sounds.play(SoundEvents.f_144049_, player, 10.0f, 1.0f);
            if (entity instanceof LivingEntity) {
                EntityMarker.mark(entity, 1L);
            }
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        DamageSource voidDamage = new DamageSource(entity.m_269291_().m_269341_().m_269150_(), (Entity)player);
        Predicate<LivingEntity> predicate = e -> e.m_19879_() != player.m_19879_();
        List<LivingEntity> nearbyEntities = InfinitySword.getNearbyLivingEntities(entity, 5.0, predicate);
        nearbyEntities.forEach(e -> {
            player.m_5704_((Entity)e);
            e.m_6469_(voidDamage, Float.MAX_VALUE);
        });
        InfinitySword.sweep(player, entity, stack, 3.4028234663852886E38);
        player.m_36334_();
        EntityMarker.mark(entity, 1L);
        return true;
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)RainbowEffectHelper.createCustomGradientText(Component.m_237115_((String)"item.eternisstarrysky.infinity_sword2").getString(), RainbowEffectHelper.DEFAULT_RAINBOW, 2.0f, 1, 0.05f, 2.0f));
        tooltip.add((Component)RainbowEffectHelper.createCustomGradientText(Component.m_237115_((String)"AIR").getString(), RainbowEffectHelper.DEFAULT_RAINBOW, 2.0f, 1, 0.05f, 2.0f));
        tooltip.add((Component)Component.m_237115_((String)"item.isMain"));
        tooltip.add((Component)RainbowEffectHelper.createCustomGradientText(Component.m_237115_((String)"item.eternisstarrysky.infinity_sword_damage_true").getString(), RainbowEffectHelper.DEFAULT_RAINBOW, 2.0f, 1, 0.05f, 2.0f).m_130946_(Component.m_237115_((String)"item.attDamage").getString()));
        tooltip.add((Component)Component.m_237113_((String)" \u00a722.0").m_130946_(Component.m_237115_((String)"item.attSpeed").getString()));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nullable
            public Font getFont(ItemStack stack, IClientItemExtensions.FontContext context) {
                if (InfinitySwordTrue.this.font == null) {
                    InfinitySwordTrue.this.font = new SinFont(Minecraft.m_91087_().f_91062_.f_92713_, true);
                }
                return InfinitySwordTrue.this.font;
            }
        });
        super.initializeClient(consumer);
    }

    public class SinFont
    extends Font {
        private static long getTimeBase() {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null) {
                return minecraft.f_91073_.m_46467_();
            }
            return System.currentTimeMillis() / 50L;
        }

        public SinFont(Function<ResourceLocation, FontSet> p_243253_, boolean p_243245_) {
            super(p_243253_, p_243245_);
        }

        private static int getGradientColor(List<Integer> colors, float position) {
            int colorCount = colors.size();
            float segment = 1.0f / (float)(colorCount - 1);
            int segmentIndex = (int)(position / segment);
            if (segmentIndex >= colorCount - 1) {
                return colors.get(colorCount - 1);
            }
            float segmentPos = position % segment / segment;
            int startColor = colors.get(segmentIndex);
            int endColor = colors.get(segmentIndex + 1);
            return SinFont.interpolateColor(startColor, endColor, segmentPos);
        }

        private static int interpolateColor(int start, int end, float progress) {
            int startR = start >> 16 & 0xFF;
            int startG = start >> 8 & 0xFF;
            int startB = start & 0xFF;
            int endR = end >> 16 & 0xFF;
            int endG = end >> 8 & 0xFF;
            int endB = end & 0xFF;
            int r = (int)((float)startR + (float)(endR - startR) * progress);
            int g = (int)((float)startG + (float)(endG - startG) * progress);
            int b = (int)((float)startB + (float)(endB - startB) * progress);
            return r << 16 | g << 8 | b;
        }

        public int m_272191_(@NotNull FormattedCharSequence formattedCharSequence, float x, float y, int rgb, boolean b1, @NotNull Matrix4f matrix4f, @NotNull MultiBufferSource multiBufferSource, @NotNull Font.DisplayMode mode, int i, int i1) {
            StringBuilder stringBuilder = new StringBuilder();
            formattedCharSequence.m_13731_((index, style, codePoint) -> {
                stringBuilder.appendCodePoint(codePoint);
                return true;
            });
            String text = ChatFormatting.m_126649_((String)stringBuilder.toString());
            float hue = (float)Util.m_137550_() / 52000.0f % 1.0f;
            float hueStep = (float)(0.025 + (Math.sin((float)Util.m_137550_() / 1200.0f) % 6.28318 + 0.9) * 0.1475 / 3.6 / 1.5);
            if (text != null) {
                for (int index2 = 0; index2 < text.length(); ++index2) {
                    String s = String.valueOf(text.charAt(index2));
                    float yOffset = (float)(Math.sin((float)index2 + (float)Util.m_137550_() / 520.0f) * 1.5);
                    float xOffset = (float)(Math.cos((float)i + (float)Util.m_137550_() / 600.0f) * 2.0);
                    int direction = 1;
                    int speed = 3;
                    float gradientSpan = 1.0f;
                    float charSpacing = 0.03f;
                    long time = SinFont.getTimeBase();
                    int index1 = direction > 0 ? i : text.length() - 1 - i;
                    float position = ((float)(time * (long)speed + (long)index2) / 100.0f + (float)i * charSpacing) % 1.0f;
                    position = position * gradientSpan % 1.0f;
                    int color = SinFont.getGradientColor(RainbowEffectHelper.BLUE, position);
                    if ((text.contains(I18n.m_118938_((String)"item.eternisstarrysky.infinity_sword_damage_true", (Object[])new Object[0])) && I18n.m_118938_((String)"item.eternisstarrysky.infinity_sword_damage_true", (Object[])new Object[0]).contains(s)) | (text.contains(I18n.m_118938_((String)"item.eternisstarrysky.infinity_sword_true", (Object[])new Object[0])) && I18n.m_118938_((String)"item.eternisstarrysky.infinity_sword_true", (Object[])new Object[0]).contains(s))) {
                        super.m_271703_(s, x, y + yOffset, color, b1, matrix4f, multiBufferSource, mode, i, i1);
                    } else {
                        super.m_271703_(s, x, y, ChatFormatting.GRAY.m_126665_().intValue(), b1, matrix4f, multiBufferSource, mode, i, i1);
                    }
                    if ((text.contains(I18n.m_118938_((String)"attribute.name.generic.attack_speed", (Object[])new Object[0])) && I18n.m_118938_((String)"attribute.name.generic.attack_speed", (Object[])new Object[0]).contains(s)) | (text.contains(I18n.m_118938_((String)"attribute.name.generic.attack_damage", (Object[])new Object[0])) && I18n.m_118938_((String)"attribute.name.generic.attack_damage", (Object[])new Object[0]).contains(s))) {
                        super.m_271703_(s, x, y, ChatFormatting.DARK_GREEN.m_126665_().intValue(), b1, matrix4f, multiBufferSource, mode, i, i1);
                    }
                    if (text.contains("2.0")) {
                        super.m_271703_(s, x, y, ChatFormatting.DARK_GREEN.m_126665_().intValue(), b1, matrix4f, multiBufferSource, mode, i, i1);
                    }
                    if (text.contains(I18n.m_118938_((String)"item.eternisstarrysky.infinity_sword2", (Object[])new Object[0]))) {
                        super.m_271703_(s, x, y, ChatFormatting.DARK_RED.m_126665_().intValue(), b1, matrix4f, multiBufferSource, mode, i, i1);
                    }
                    hue += hueStep;
                    hue %= 1.0f;
                    x += (float)this.m_92895_(s);
                }
            }
            return (int)x;
        }
    }
}

