/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;

public class RainbowEffectHelper {
    private static final float DEFAULT_SPEED = 1.0f;
    private static final int DEFAULT_DIRECTION = 1;
    private static final float DEFAULT_SATURATION = 1.0f;
    private static final float DEFAULT_BRIGHTNESS = 1.0f;
    private static final float DEFAULT_CHAR_SPACING = 0.05f;
    public static final List<Integer> DEFAULT_RAINBOW = Arrays.asList(0xFF0000, 0xFF7F00, 0xFFFF00, 0x7FFF00, 65280, 65407, 65535, Short.MAX_VALUE, 255, 0x3F00FF, 0x7F00FF, 0xFF00FF, 0xFF007F, 0xFF0000);
    public static final List<Integer> DEFAULT_RAINBOW_PRO = Arrays.asList(0xFF0000, 0xFF7F00, 0xFF7F00, 0xFFFF00, 0xFFFF00, 0x7FFF00, 0x7FFF00, 65280, 65280, 65407, 65407, 65535, 65535, Short.MAX_VALUE, Short.MAX_VALUE, 255, 255, 255, 255, 0x7F00FF, 0x7F00FF, 0xFF00FF, 0xFF00FF, 0xFF007F, 0xFF007F, 0xFF0000, 0xFF0000);
    public static final List<Integer> BLUE = Arrays.asList(52479, 12031, 12031, 65474, 65474, 52479);

    public static MutableComponent createCustomGradientText(String text, List<Integer> colors, float speed, int direction, float charSpacing, float gradientSpan) {
        long time = RainbowEffectHelper.getTimeBase();
        if (colors.size() < 2) {
            colors = new ArrayList<Integer>(colors);
            colors.add(colors.get(0));
        }
        MutableComponent gradientText = Component.m_237119_();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            int index = direction > 0 ? i : length - 1 - i;
            float position = ((float)time * speed / 100.0f + (float)i * charSpacing) % 1.0f;
            position = position * gradientSpan % 1.0f;
            int color = RainbowEffectHelper.getGradientColor(colors, position);
            gradientText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(index))).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color))));
        }
        return gradientText;
    }

    private static int getGradientColor(List<Integer> colors, float position) {
        int colorCount = colors.size();
        float segment = 1.0f / (float)(colorCount - 1);
        int segmentIndex = (int)(position / segment);
        if (segmentIndex >= colorCount - 1) {
            return colors.get(colorCount - 1);
        }
        float segmentPos = position % segment / segment;
        int startColor = colors.get(segmentIndex);
        int endColor = colors.get(segmentIndex + 1);
        return RainbowEffectHelper.interpolateColor(startColor, endColor, segmentPos);
    }

    private static int interpolateColor(int start, int end, float progress) {
        int startR = start >> 16 & 0xFF;
        int startG = start >> 8 & 0xFF;
        int startB = start & 0xFF;
        int endR = end >> 16 & 0xFF;
        int endG = end >> 8 & 0xFF;
        int endB = end & 0xFF;
        int r = (int)((float)startR + (float)(endR - startR) * progress);
        int g = (int)((float)startG + (float)(endG - startG) * progress);
        int b = (int)((float)startB + (float)(endB - startB) * progress);
        return r << 16 | g << 8 | b;
    }

    public static MutableComponent createRainbowText(String text, float speed, int direction, float saturation, float brightness, float charSpacing) {
        long time = RainbowEffectHelper.getTimeBase();
        MutableComponent rainbowText = Component.m_237119_();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            int index = direction > 0 ? i : length - 1 - i;
            float hue = ((float)time * speed / 100.0f + (float)i * charSpacing) % 1.0f;
            int rgb = RainbowEffectHelper.HSBtoRGB(hue, saturation, brightness);
            rainbowText.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(index))).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb))));
        }
        return rainbowText;
    }

    public static MutableComponent createRainbowText(String text, float speed, int direction, float charSpacing) {
        return RainbowEffectHelper.createCustomGradientText(text, DEFAULT_RAINBOW, speed, direction, charSpacing, 1.0f);
    }

    public static MutableComponent createRainbowText(String text) {
        return RainbowEffectHelper.createRainbowText(text, 1.0f, 1, 1.0f, 1.0f, 0.05f);
    }

    private static long getTimeBase() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null) {
            return minecraft.f_91073_.m_46467_();
        }
        return System.currentTimeMillis() / 50L;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Mth.m_14143_((float)hue)) * 6.0f;
            float f = h - (float)Mth.m_14143_((float)h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

