/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.Render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LightningBolt;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PurpleLightningRenderer
extends EntityRenderer<LightningBolt> {
    public boolean useRainbow = true;
    private final LightningBoltRenderer vanillaRenderer;

    public PurpleLightningRenderer(EntityRendererProvider.Context p_174286_) {
        super(p_174286_);
        this.vanillaRenderer = new LightningBoltRenderer(p_174286_);
    }

    public void render(LightningBolt lightning, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (lightning.m_19879_() > 199999999) {
            this.LightningRainbow(lightning, entityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRenderer.m_7392_(lightning, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void LightningRainbow(LightningBolt lightning, float partialTicks, float something, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float[] afloat = new float[8];
        float[] afloat1 = new float[8];
        float f = 0.0f;
        float f1 = 0.0f;
        RandomSource randomsource = RandomSource.m_216335_((long)lightning.f_20859_);
        for (int i = 7; i >= 0; --i) {
            afloat[i] = f;
            afloat1[i] = f1;
            f += (float)(randomsource.m_188503_(11) - 5);
            f1 += (float)(randomsource.m_188503_(11) - 5);
        }
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110502_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RandomSource random = RandomSource.m_216335_((long)lightning.f_20859_);
        long worldTime = lightning.m_9236_().m_46467_();
        float timeOffset = ((float)worldTime + partialTicks) * 0.1f;
        for (int j = 0; j < 4; ++j) {
            RandomSource randomsource1 = RandomSource.m_216335_((long)lightning.f_20859_);
            for (int k = 0; k < 3; ++k) {
                int l = 7;
                int i1 = 0;
                if (k > 0) {
                    l = 7 - k;
                }
                if (k > 0) {
                    i1 = l - 2;
                }
                float f2 = afloat[l] - f;
                float f3 = afloat1[l] - f1;
                for (int j1 = l; j1 >= i1; --j1) {
                    float f4 = f2;
                    float f5 = f3;
                    if (k == 0) {
                        f2 += (float)(randomsource1.m_188503_(11) - 5);
                        f3 += (float)(randomsource1.m_188503_(11) - 5);
                    } else {
                        f2 += (float)(randomsource1.m_188503_(31) - 15);
                        f3 += (float)(randomsource1.m_188503_(31) - 15);
                    }
                    float f10 = 0.1f + (float)j * 0.2f;
                    if (k == 0) {
                        f10 *= (float)j1 * 0.1f + 1.0f;
                    }
                    float f11 = 0.1f + (float)j * 0.2f;
                    if (k == 0) {
                        f11 *= ((float)j1 - 1.0f) * 0.1f + 1.0f;
                    }
                    float heightRatio = (float)j1 / 7.0f;
                    float[] auroraColor = PurpleLightningRenderer.getAuroraColor(heightRatio, timeOffset, lightning.f_20859_ + (long)j1);
                    PurpleLightningRenderer.quadGradient(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, auroraColor[0], auroraColor[1], auroraColor[2], f11, f10, heightRatio, timeOffset, lightning.f_20859_ + (long)j1, false, false, true, false);
                    PurpleLightningRenderer.quadGradient(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, auroraColor[0], auroraColor[1], auroraColor[2], f11, f10, heightRatio, timeOffset, lightning.f_20859_ + (long)j1, true, false, true, true);
                    PurpleLightningRenderer.quadGradient(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, auroraColor[0], auroraColor[1], auroraColor[2], f11, f10, heightRatio, timeOffset, lightning.f_20859_ + (long)j1, true, true, false, true);
                    PurpleLightningRenderer.quadGradient(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, auroraColor[0], auroraColor[1], auroraColor[2], f11, f10, heightRatio, timeOffset, lightning.f_20859_ + (long)j1, false, true, false, false);
                }
            }
        }
    }

    private static void quadGradient(Matrix4f matrix, VertexConsumer buffer, float x1, float z1, int y1, float x2, float z2, float r, float g, float b, float width2, float width1, float heightRatio, float timeOffset, long seed, boolean p1, boolean p2, boolean p3, boolean p4) {
        float[] bottomColor = PurpleLightningRenderer.getAuroraColor(heightRatio, timeOffset, seed);
        float[] topColor = PurpleLightningRenderer.getAuroraColor(heightRatio + 0.1f, timeOffset, seed + 1L);
        buffer.m_252986_(matrix, x1 + (p1 ? width1 : -width1), (float)(y1 * 16), z1 + (p2 ? width1 : -width1)).m_85950_(bottomColor[0], bottomColor[1], bottomColor[2], 0.3f).m_5752_();
        buffer.m_252986_(matrix, x2 + (p1 ? width2 : -width2), (float)((y1 + 1) * 16), z2 + (p2 ? width2 : -width2)).m_85950_(topColor[0], topColor[1], topColor[2], 0.3f).m_5752_();
        buffer.m_252986_(matrix, x2 + (p3 ? width2 : -width2), (float)((y1 + 1) * 16), z2 + (p4 ? width2 : -width2)).m_85950_(topColor[0], topColor[1], topColor[2], 0.3f).m_5752_();
        buffer.m_252986_(matrix, x1 + (p3 ? width1 : -width1), (float)(y1 * 16), z1 + (p4 ? width1 : -width1)).m_85950_(bottomColor[0], bottomColor[1], bottomColor[2], 0.3f).m_5752_();
    }

    private static float[] getAuroraColor(float heightRatio, float timeOffset, long seed) {
        RandomSource random = RandomSource.m_216335_((long)seed);
        float baseHue = (heightRatio * 0.8f + timeOffset * 0.5f + random.m_188501_() * 0.3f) % 1.0f;
        float hue = baseHue < 0.4f ? 0.33f + baseHue * 0.17f : (baseHue < 0.7f ? 0.55f + (baseHue - 0.4f) * 0.17f : 0.72f + (baseHue - 0.7f) * 0.17f);
        float saturation = 0.6f + heightRatio * 0.4f;
        float brightness = 0.5f + heightRatio * 0.5f;
        return PurpleLightningRenderer.hsvToRgb(hue, saturation, brightness);
    }

    private static float[] hsvToRgb(float h, float s, float v) {
        float b;
        float g;
        float r;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h * 6.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 0.16666667f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h < 0.33333334f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h < 0.5f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h < 0.6666667f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h < 0.8333333f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new float[]{r + m, g + m, b + m};
    }

    public ResourceLocation getTextureLocation(LightningBolt p_115264_) {
        return TextureAtlas.f_118259_;
    }
}

