/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.config.menu;

import com.baizeli.eternisstarrysky.config.menu.ConfigValue;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class ConfigArray
extends ScrollPanel {
    private final List<ConfigValue> value = new LinkedList<ConfigValue>();
    private int previousY = Integer.MIN_VALUE;
    private final int x;

    public ConfigArray(Minecraft client, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.x = left;
    }

    protected int getContentHeight() {
        int content = 0;
        for (ConfigValue value : this.value) {
            if (!value.visible) continue;
            content += value.height + 6;
        }
        return content - 6;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        relativeY -= 4;
        if (this.height >= this.getContentHeight()) {
            relativeY = 6;
        }
        this.previousY = relativeY;
        for (ConfigValue configValue : this.value) {
            if (!configValue.visible) continue;
            configValue.draw(guiGraphics, this.x, relativeY, mouseX, mouseY);
            relativeY += configValue.height + 6;
        }
    }

    protected void drawBackground(GuiGraphics guiGraphics, Tesselator tess, float partialTick) {
        super.drawBackground(guiGraphics, tess, partialTick);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.click(mouseX, mouseY)) {
            return true;
        }
        this.m_7522_(null);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void push(ConfigValue value) {
        value.width = this.width;
        value.parent = this;
        this.value.add(value);
    }

    public boolean click(double x, double y) {
        if (y < 6.0) {
            return false;
        }
        if (y > (double)(this.height + 6)) {
            return false;
        }
        if (x < 6.0) {
            return false;
        }
        if (x > (double)(this.width + 6)) {
            return false;
        }
        double y1 = y - (double)this.previousY;
        int cy = 0;
        for (ConfigValue configValue : this.value) {
            if (!configValue.visible) continue;
            if ((double)cy > y1) {
                return false;
            }
            if ((double)(cy + configValue.height) >= y1) {
                return configValue.click(x, y);
            }
            cy += configValue.height + 6;
        }
        return false;
    }
}

