/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.config.menu;

import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ConfigValue {
    public static final int COLOR_DEFAULT = 0;
    public static final int COLOR_HOVER = 1;
    public static final int COLOR_INACTIVE = 2;
    public AbstractContainerEventHandler parent;
    public final String key;
    public final Font font;
    public AbstractWidget valueWidget;
    public boolean visible = true;
    public boolean active = true;
    public Component tooltip;
    public int width = 200;
    public int valueWidth = 100;
    public int height = 20;
    public int lineHeight = 20;
    public int indent = 50;
    public final StringWidget text;
    public boolean resetEnable = true;
    public boolean resetActive = false;
    private final Button reset;
    public int previousX;
    public int previousY;
    public double mouseX;
    public double mouseY;
    public final int[] color = new int[]{0xFFFFFF, 0xFFFF55, 0x555555};
    public Consumer<ConfigValue> resetValue = null;

    public ConfigValue(AbstractContainerEventHandler parent, String key, Font font) {
        this.parent = parent;
        this.key = key;
        this.font = font;
        int textWidth = this.width - 2 * this.indent - this.valueWidth - 6;
        int x = this.previousX;
        int y = this.previousY;
        this.text = new StringWidget(x + this.indent, y, textWidth, this.lineHeight, (Component)Component.m_237115_((String)this.key), this.font);
        this.text.m_267769_();
        this.reset = new Button.Builder((Component)Component.m_237113_((String)"\u00a7c\u00d7"), this::onReset).m_252987_(x + this.width - this.indent + 6, y, this.lineHeight, this.lineHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"eternisstarrysky.config.reset"))).m_253136_();
    }

    public AbstractWidget updateWidget(AbstractWidget widget) {
        int widgetX = this.previousX + (this.width - this.valueWidth - this.indent);
        if (this.valueWidget != null) {
            widget.m_264152_(widgetX, this.previousY);
        }
        return widget;
    }

    public void draw(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        this.previousX = x;
        this.previousY = y;
        this.text.m_264152_(x + this.indent, y);
        this.text.m_93674_(this.width - 2 * this.indent - this.valueWidth - 6);
        this.reset.m_264152_(x + this.width - this.indent + 6, y);
        this.valueWidget = this.updateWidget(this.valueWidget);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int textColor = this.color[this.hoverText() ? 1 : 0];
        if (!this.active) {
            textColor = this.color[2];
        }
        this.text.m_269033_(textColor);
        this.text.f_93623_ = this.active;
        if (this.tooltip != null) {
            this.text.m_257544_(Tooltip.m_257550_((Component)this.tooltip));
        }
        if (this.valueWidget != null) {
            this.valueWidget.f_93623_ = this.active;
        }
        boolean bl = this.resetActive = this.active && this.resetValue != null;
        if (this.resetEnable) {
            this.reset.f_93623_ = this.resetActive;
        }
        this.update();
        this.text.m_88315_(graphics, mouseX, mouseY, 0.0f);
        if (this.valueWidget != null) {
            this.valueWidget.m_88315_(graphics, mouseX, mouseY, 0.0f);
        }
        if (this.resetEnable) {
            this.reset.m_88315_(graphics, mouseX, mouseY, 0.0f);
        }
    }

    public boolean click(double x, double y) {
        if (!this.active) {
            return false;
        }
        if (this.text.m_6375_(x, y, 0)) {
            this.parent.m_7522_(null);
            this.clickText();
            return true;
        }
        if (this.valueWidget != null && this.valueWidget.m_6375_(x, y, 0)) {
            this.parent.m_7522_((GuiEventListener)this.valueWidget);
            this.clickWidget();
            return true;
        }
        if (this.resetActive && this.reset.m_6375_(x, y, 0)) {
            this.parent.m_7522_((GuiEventListener)this.reset);
            return true;
        }
        return false;
    }

    public boolean hoverText() {
        int textWidth = this.text.m_5711_();
        if (this.mouseX < (double)(this.previousX + this.indent)) {
            return false;
        }
        if (this.mouseX > (double)(this.previousX + this.indent + textWidth)) {
            return false;
        }
        if (this.mouseY < (double)this.previousY) {
            return false;
        }
        return !(this.mouseY > (double)(this.previousY + this.lineHeight));
    }

    public void visible(boolean visible) {
        this.visible = visible;
    }

    public void update() {
    }

    public void clickText() {
    }

    public void clickWidget() {
    }

    public void onReset(Button button) {
        if (this.resetValue != null) {
            this.resetValue.accept(this);
        }
    }
}

