/*
 * Decompiled with CFR 0.152.
 */
package com.baizeli.eternisstarrysky.config.menu;

import com.baizeli.eternisstarrysky.Configuration;
import com.baizeli.eternisstarrysky.config.ConfigEffect;
import com.baizeli.eternisstarrysky.config.menu.ConfigValue;
import com.baizeli.eternisstarrysky.config.menu.EffectEntry;
import com.baizeli.eternisstarrysky.config.menu.SuggestionEdit;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EffectArrayValue
extends ConfigValue {
    public ImmutableList<ConfigEffect> defaultValue;
    private boolean expand = false;
    public final ArrayList<EffectEntry> value = new ArrayList();
    private final Button addon;
    private final byte[] buffer = new byte[4096];

    public EffectArrayValue(Screen screen, String key, Font font) {
        super((AbstractContainerEventHandler)screen, key, font);
        this.resetEnable = true;
        this.addon = new Button.Builder((Component)Component.m_237113_((String)"+"), this::onAddon).m_253046_(this.boxWidth(), this.lineHeight).m_253136_();
        this.resetValue = this::reset;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        super.draw(graphics, x, y, mouseX, mouseY);
        x += this.indent + 2 * this.lineHeight + 6;
        y += this.lineHeight + 6;
        for (EffectEntry entry : this.value) {
            entry.remove.m_264152_(x - this.lineHeight - 6, y);
            entry.remove.m_93674_(this.lineHeight);
            entry.remove.setHeight(this.lineHeight);
            int boxWidth = this.boxWidth();
            int idWidth = (boxWidth - 6) / 2;
            int numWidth = (boxWidth - idWidth - 12) / 2;
            entry.ID.m_264152_(x, y);
            entry.ID.m_93674_(idWidth);
            entry.ID.setHeight(this.lineHeight);
            entry.duration.m_264152_(x + idWidth + 6, y);
            entry.duration.m_93674_(numWidth);
            entry.duration.setHeight(this.lineHeight);
            entry.amplifier.m_264152_(x + idWidth + numWidth + 12, y);
            entry.amplifier.m_93674_(numWidth);
            entry.amplifier.setHeight(this.lineHeight);
            int valLen = entry.ID.m_94155_().length();
            int hintLength = Configuration.searchEffectID(entry.ID.m_94155_(), this.buffer);
            if (hintLength > 0) {
                entry.ID.m_94167_(new String(this.buffer, valLen, hintLength - valLen));
            } else {
                entry.ID.m_94167_("");
            }
            y += this.lineHeight + 6;
        }
        this.addon.m_264152_(x, y);
        this.addon.m_93674_(this.boxWidth());
        this.addon.setHeight(this.lineHeight);
        this.updateHeight();
        if (!this.expand) {
            return;
        }
        for (EffectEntry value : this.value) {
            value.remove.m_88315_(graphics, mouseX, mouseY, 0.0f);
            int color = 0xFF5555;
            if (Configuration.validateMobEffect(value.ID.m_94155_())) {
                color = 0x55FF55;
            }
            value.ID.m_94202_(color);
            value.ID.m_88315_(graphics, mouseX, mouseY, 0.0f);
            value.duration.m_88315_(graphics, mouseX, mouseY, 0.0f);
            value.amplifier.m_88315_(graphics, mouseX, mouseY, 0.0f);
        }
        this.addon.m_88315_(graphics, mouseX, mouseY, 0.0f);
    }

    @Override
    public boolean click(double x, double y) {
        if (super.click(x, y)) {
            return true;
        }
        if (x < (double)this.indent || x > (double)(this.previousX + this.width - this.indent)) {
            return false;
        }
        if (!this.expand) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < this.value.size(); ++i) {
            EffectEntry value = this.value.get(i);
            GuiEventListener elem = value.click(x, y);
            if (elem == value.remove) {
                this.value.remove(i);
                return true;
            }
            if (elem == null) continue;
            flag = true;
            this.parent.m_7522_(elem);
            break;
        }
        if (flag) {
            return true;
        }
        flag = this.addon.m_6375_(x, y, 0);
        if (flag) {
            this.parent.m_7522_((GuiEventListener)this.addon);
        }
        return flag;
    }

    @Override
    public void update() {
        this.resetActive = this.defaultValue != null;
    }

    @Override
    public void clickText() {
        this.expand = !this.expand;
        this.updateHeight();
    }

    public void reset(ConfigValue ignored) {
        this.value((List<? extends ConfigEffect>)this.defaultValue);
    }

    public void updateHeight() {
        int newHeight = this.lineHeight;
        if (this.expand) {
            newHeight += (this.value.size() + 1) * (this.lineHeight + 6) + 6;
        }
        this.height = newHeight;
    }

    public void onAddon(Button b) {
        this.value.add(this.entry(new ConfigEffect("", 0, 0)));
    }

    public void value(List<? extends ConfigEffect> value) {
        this.value.clear();
        for (ConfigEffect configEffect : value) {
            this.value.add(this.entry(configEffect));
        }
    }

    public List<ConfigEffect> value() {
        LinkedList<ConfigEffect> list = new LinkedList<ConfigEffect>();
        for (EffectEntry value : this.value) {
            if (value.ID.m_94155_().isEmpty()) continue;
            list.add(new ConfigEffect(value.ID.m_94155_(), Integer.parseInt(value.duration.m_94155_()), Integer.parseInt(value.amplifier.m_94155_())));
        }
        return list;
    }

    public EffectEntry entry(ConfigEffect eff) {
        EffectEntry entry = new EffectEntry();
        entry.remove = new Button.Builder((Component)Component.m_237113_((String)"\u00a7c-"), b -> {}).m_253046_(this.lineHeight, this.lineHeight).m_253136_();
        int x = this.previousX + this.indent + 2 * this.lineHeight + 6;
        int y = this.previousY + this.lineHeight + 6;
        int boxWidth = this.boxWidth();
        int editWidth = (boxWidth - 12) / 3;
        entry.ID = new SuggestionEdit(this.font, x, y, editWidth, this.lineHeight, (Component)Component.m_237119_());
        entry.ID.m_94144_(eff.key);
        entry.ID.m_94208_(0);
        entry.ID.m_94196_(0);
        entry.duration = new EditBox(this.font, x += editWidth + 6, y, editWidth, this.lineHeight, (Component)Component.m_237119_());
        entry.duration.m_94144_(String.valueOf(eff.duration));
        entry.duration.m_94208_(0);
        entry.duration.m_94196_(0);
        entry.duration.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"0 ~ 2147483647")));
        entry.duration.m_94151_(entry::duration);
        entry.amplifier = new EditBox(this.font, x += editWidth + 6, y, editWidth, this.lineHeight, (Component)Component.m_237119_());
        entry.amplifier.m_94144_(String.valueOf(eff.amplifier));
        entry.amplifier.m_94208_(0);
        entry.amplifier.m_94196_(0);
        entry.amplifier.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"0 ~ 255")));
        entry.amplifier.m_94151_(entry::amplifier);
        return entry;
    }

    public int boxWidth() {
        return this.width - 2 * this.indent - 2 * this.lineHeight - 6;
    }
}

