/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached;

import dev.furq.resourcepackcached.utils.CachingUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.client.resources.server.PackReloadConfig;
import net.minecraft.client.resources.server.ServerPackManager;
import net.neoforged.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod(value="rpc")
public class ResourcePackCached {
    public ResourcePackCached() {
        HashMap<UUID, Path> cachedPacks = CachingUtils.readCacheFile();
        if (!cachedPacks.isEmpty()) {
            try {
                CachingUtils.isStartup = true;
                final DownloadedPackSource packSource = Minecraft.getInstance().getDownloadedPackSource();
                packSource.manager.packPromptStatus = ServerPackManager.PackPromptStatus.ALLOWED;
                cachedPacks.entrySet().stream().filter(entry -> Files.exists((Path)entry.getValue(), new LinkOption[0])).forEach(entry -> packSource.pushLocalPack((UUID)entry.getKey(), (Path)entry.getValue()));
                packSource.manager.packs.forEach(pack -> {
                    pack.activationStatus = ServerPackManager.ActivationStatus.ACTIVE;
                });
                packSource.startReload(new PackReloadConfig.Callbacks(){

                    @NotNull
                    public List<PackReloadConfig.IdAndPath> packsToLoad() {
                        return packSource.manager.packs.stream().map(pack -> new PackReloadConfig.IdAndPath(pack.id, pack.path)).toList();
                    }

                    public void onSuccess() {
                    }

                    public void onFailure(boolean bl) {
                    }
                });
            }
            catch (Exception exception) {
            }
            finally {
                CachingUtils.isStartup = false;
            }
        }
    }
}

