/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached.mixin;

import com.google.common.hash.HashCode;
import dev.furq.resourcepackcached.utils.CachingUtils;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.resources.server.PackLoadFeedback;
import net.minecraft.client.resources.server.ServerPackManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPackManager.class})
abstract class ServerPackManagerMixin {
    @Unique
    private final HashMap<UUID, Path> latestPacks = new HashMap();
    @Final
    @Shadow
    PackLoadFeedback packLoadFeedback;
    @Unique
    private boolean isNewSequence = true;

    ServerPackManagerMixin() {
    }

    @Shadow
    public abstract void popPack(UUID var1);

    @Shadow
    abstract void registerForUpdate();

    @Inject(method={"pushPack(Ljava/util/UUID;Ljava/net/URL;Lcom/google/common/hash/HashCode;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPushPack(UUID id, URL url, @Nullable HashCode hashCode, CallbackInfo ci) {
        if (this.isNewSequence) {
            this.latestPacks.clear();
            this.isNewSequence = false;
        }
        if (hashCode != null) {
            Path downloadPath = new File(CachingUtils.GAME_DIR, "downloads/" + String.valueOf(id) + "/" + String.valueOf(hashCode)).toPath();
            this.latestPacks.put(id, downloadPath);
            if (CachingUtils.isCachedResourcePack(id, hashCode)) {
                this.packLoadFeedback.reportFinalResult(id, PackLoadFeedback.FinalResult.APPLIED);
                this.registerForUpdate();
                ci.cancel();
            }
        }
    }

    @Inject(method={"onDownload(Ljava/util/Collection;Lnet/minecraft/server/packs/DownloadQueue$BatchResult;)V"}, at={@At(value="RETURN")})
    public void afterDownload(CallbackInfo ci) {
        this.isNewSequence = true;
        if (!this.latestPacks.isEmpty()) {
            HashMap<UUID, Path> cachedPacks = CachingUtils.readCacheFile();
            cachedPacks.keySet().stream().filter(uuid -> !this.latestPacks.containsKey(uuid)).forEach(this::popPack);
            CachingUtils.writeCacheFile(this.latestPacks);
        }
    }

    @Inject(method={"registerForUpdate()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRegisterForUpdate(CallbackInfo ci) {
        if (CachingUtils.isStartup) {
            ci.cancel();
        }
    }

    @Inject(method={"triggerReloadIfNeeded()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTriggerReloadIfNeeded(CallbackInfo ci) {
        if (CachingUtils.isStartup) {
            ci.cancel();
        }
    }

    @Inject(method={"popAll()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPopAll(CallbackInfo ci) {
        this.latestPacks.clear();
        ci.cancel();
    }
}

