/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached.utils;

import com.google.common.hash.HashCode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingUtils {
    public static final File GAME_DIR = FMLPaths.GAMEDIR.get().toFile();
    public static final File CONFIG_DIR = FMLPaths.CONFIGDIR.get().toFile();
    public static final File CACHE_FILE = new File(CONFIG_DIR, "rpc-data.json");
    public static final Logger LOGGER = LogManager.getLogger((String)"ResourcePackCached");
    public static boolean isStartup = false;

    public static void writeCacheFile(HashMap<UUID, Path> packs) {
        try {
            JsonObject root = new JsonObject();
            JsonArray packsArray = new JsonArray();
            for (Map.Entry<UUID, Path> entry : packs.entrySet()) {
                if (!Files.exists(entry.getValue(), new LinkOption[0])) continue;
                JsonObject packObj = new JsonObject();
                packObj.addProperty("uuid", entry.getKey().toString());
                packObj.addProperty("path", entry.getValue().toString());
                packsArray.add((JsonElement)packObj);
            }
            root.add("packs", (JsonElement)packsArray);
            FileUtils.writeStringToFile((File)CACHE_FILE, (String)root.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write cache file", (Throwable)e);
        }
    }

    public static HashMap<UUID, Path> readCacheFile() {
        HashMap<UUID, Path> packs = new HashMap<UUID, Path>();
        if (CACHE_FILE.exists()) {
            try {
                JsonObject root;
                JsonArray packsArray;
                String content = FileUtils.readFileToString((File)CACHE_FILE, (Charset)StandardCharsets.UTF_8);
                if (!content.isEmpty() && (packsArray = (root = JsonParser.parseString((String)content).getAsJsonObject()).getAsJsonArray("packs")) != null) {
                    for (int i = 0; i < packsArray.size(); ++i) {
                        JsonObject packObj = packsArray.get(i).getAsJsonObject();
                        UUID uuid = UUID.fromString(packObj.get("uuid").getAsString());
                        Path path = Paths.get(packObj.get("path").getAsString(), new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) continue;
                        packs.put(uuid, path);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read cache file", (Throwable)e);
            }
        }
        return packs;
    }

    public static boolean isCachedResourcePack(UUID uuid, HashCode hashCode) {
        Path cachedPath = CachingUtils.readCacheFile().get(uuid);
        return cachedPath != null && cachedPath.getFileName().toString().equals(hashCode.toString());
    }
}

