/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.highlightItem;

import be.elmital.highlightItem.HighlightItem;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_9848;

public class Colors {
    public static float[] customFromJson(JsonObject json) {
        if (json.has("custom")) {
            try {
                return new float[]{json.get("red").getAsFloat(), json.get("green").getAsFloat(), json.get("blue").getAsFloat(), json.get("alpha").getAsFloat()};
            }
            catch (IllegalStateException | UnsupportedOperationException e) {
                HighlightItem.LOGGER.error("Can't convert json to a rgba color don't try to change manually the config file! Actual json is " + String.valueOf(json));
                return HighLightColor.DEFAULT.getShaderColor();
            }
        }
        HighlightItem.LOGGER.error("Can't convert json to color don't try to change manually the config file! Actual json is " + String.valueOf(json));
        return HighLightColor.DEFAULT.getShaderColor();
    }

    public static JsonObject customToJson(float[] rgba) {
        JsonObject json = new JsonObject();
        json.addProperty("custom", "");
        json.addProperty("red", (Number)Float.valueOf(rgba[0]));
        json.addProperty("green", (Number)Float.valueOf(rgba[1]));
        json.addProperty("blue", (Number)Float.valueOf(rgba[2]));
        json.addProperty("alpha", (Number)Float.valueOf(rgba[3]));
        return json;
    }

    public static enum HighLightColor {
        DEFAULT(new float[]{1.0f, 1.0f, 1.0f, 0.45f}),
        BLUE(new float[]{0.5f, 1.0f, 1.0f, 0.45f}),
        YELLOW(new float[]{1.0f, 1.0f, 0.0f, 0.45f}),
        RED(new float[]{1.0f, 0.0f, 0.0f, 0.45f}),
        GREEN(new float[]{0.0f, 1.0f, 0.0f, 0.45f});

        private final float[] shaderColor;

        private HighLightColor(float[] shaderColor) {
            this.shaderColor = shaderColor;
        }

        public float[] getShaderColor() {
            return this.shaderColor;
        }

        JsonObject json() {
            JsonObject json = new JsonObject();
            json.addProperty("default", this.name());
            return json;
        }

        public static HighLightColor fromJson(JsonObject json) {
            try {
                String name = json.get("default").getAsString();
                return HighLightColor.valueOf(name);
            }
            catch (IllegalStateException | UnsupportedOperationException e) {
                HighlightItem.LOGGER.error("Can't convert json to HighLightColor don't try to change manually the config file! Actual json is " + String.valueOf(json));
                return DEFAULT;
            }
        }

        public int colorInteger() {
            return class_9848.method_61324((int)((int)(this.shaderColor[3] * 255.0f)), (int)((int)(this.shaderColor[0] * 255.0f)), (int)((int)(this.shaderColor[1] * 255.0f)), (int)((int)(this.shaderColor[2] * 255.0f)));
        }
    }

    public static class HighLightColorArgumentType
    implements ArgumentType<HighLightColor> {
        private static final Collection<String> EXAMPLES = HighLightColorArgumentType.generateExamples();

        public static HighLightColorArgumentType color() {
            return new HighLightColorArgumentType();
        }

        public static <S> HighLightColor getColor(String name, CommandContext<S> context) {
            return (HighLightColor)((Object)context.getArgument(name, HighLightColor.class));
        }

        public HighLightColor parse(StringReader reader) throws CommandSyntaxException {
            int areBeginning = reader.getCursor();
            if (!reader.canRead()) {
                reader.skip();
            }
            while (reader.canRead() && reader.peek() != ' ') {
                reader.skip();
            }
            String colorString = reader.getString().substring(areBeginning, reader.getCursor());
            try {
                return HighLightColor.valueOf(colorString.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)iae.getMessage())).createWithContext((ImmutableStringReader)reader);
            }
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }

        private static Collection<String> generateExamples() {
            return Arrays.stream(HighLightColor.values()).map(highLightColor -> highLightColor.name().toLowerCase()).toList();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9265(EXAMPLES, (SuggestionsBuilder)builder);
        }
    }
}

