/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.highlightItem;

import be.elmital.highlightItem.Colors;
import be.elmital.highlightItem.HighlightItem;
import be.elmital.highlightItem.ItemComparator;
import be.elmital.highlightItem.mixin.SystemToastAccessor;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5348;
import net.minecraft.class_7291;
import net.minecraft.class_746;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class Configurator {
    public static boolean TOGGLE;
    public static class_304 TOGGLE_BIND;
    private final Path currentDirectory;
    public static int COLOR;
    public static class_304 COLOR_MENU;
    public static boolean COLOR_HOVERED;
    public static class_304 COLOR_HOVERED_BIND;
    public static ItemComparator.Comparators COMPARATOR;
    public static class_304 COMPARATOR_BIND;
    public static NotificationPreference NOTIFICATION_PREFERENCE;
    private final String CONFIG = "HighLightItemConfig";
    private final Properties properties = new Properties();
    public static class_370 activeToastNotification;

    public static Configurator getInstance() throws IOException, URISyntaxException {
        return new Configurator();
    }

    public Configurator() throws IOException {
        this.currentDirectory = FabricLoader.getInstance().getConfigDir();
        this.loadOrGenerateConfig();
    }

    public void loadOrGenerateConfig() throws IOException, IllegalArgumentException {
        float[] colors;
        if (Files.exists(this.getConfigPath(), new LinkOption[0])) {
            FileInputStream input = new FileInputStream(this.getConfigPath().toString());
            this.properties.load(input);
        } else {
            FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
            for (Config value : Config.values()) {
                this.properties.setProperty(value.getKey(), value.getDefault());
            }
            this.properties.store(stream, null);
        }
        TOGGLE = Boolean.parseBoolean(this.properties.getProperty(Config.TOGGLE.getKey(), Config.TOGGLE.getDefault()));
        if (this.properties.containsKey("color")) {
            JsonObject jsonColor = JsonParser.parseString((String)this.properties.getProperty(Config.COLOR.getKey())).getAsJsonObject();
            colors = jsonColor.has("default") ? Colors.HighLightColor.fromJson(jsonColor).getShaderColor() : Colors.customFromJson(jsonColor);
        } else {
            Colors.HighLightColor highlightColor = Colors.HighLightColor.valueOf(this.properties.getProperty("highlight-color", Colors.HighLightColor.DEFAULT.name()));
            colors = highlightColor.getShaderColor();
            this.removeFromConfig("highlight-color");
            this.updateConfig(Config.COLOR, highlightColor.json().toString());
        }
        COLOR = class_9848.method_61324((int)((int)(colors[3] * 255.0f)), (int)((int)(colors[0] * 255.0f)), (int)((int)(colors[1] * 255.0f)), (int)((int)(colors[2] * 255.0f)));
        COLOR_HOVERED = Boolean.parseBoolean(this.properties.getProperty(Config.COLOR_HOVERED.getKey(), Config.COLOR_HOVERED.getDefault()));
        COMPARATOR = ItemComparator.Comparators.valueOf(this.properties.getProperty(Config.COMPARATOR.getKey(), Config.COMPARATOR.getDefault()));
        NOTIFICATION_PREFERENCE = NotificationPreference.valueOf(this.properties.getProperty(Config.NOTIFICATION_PREFERENCE.getKey(), Config.NOTIFICATION_PREFERENCE.getDefault()));
    }

    public Path getConfigDirectoryPath() {
        return this.currentDirectory;
    }

    public Path getConfigPath() {
        return this.getConfigDirectoryPath().resolve("HighLightItemConfig");
    }

    public void updateConfig(Config config, String value) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
        this.properties.setProperty(config.getKey(), value);
        this.properties.store(stream, null);
    }

    public void removeFromConfig(String key) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.getConfigPath().toString());
        this.properties.remove(key);
        this.properties.store(stream, null);
    }

    public void updateToggle(class_746 player, NotificationContext notification) {
        TOGGLE = !TOGGLE;
        try {
            HighlightItem.configurator.updateConfig(Config.TOGGLE, "" + TOGGLE);
            this.notify(notification, (class_2561)(TOGGLE ? class_2561.method_43471((String)"notification.highlightitem.highlighting.update").method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)"notification.highlightitem.activate")).method_27692(class_124.field_1080) : class_2561.method_43471((String)"notification.highlightitem.highlighting.update").method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)"notification.highlightitem.deactivate")).method_27692(class_124.field_1063)), player);
        }
        catch (IOException e) {
            this.notify(notification, (class_2561)class_2561.method_43471((String)"notification.highlightitem.config.update.fail").method_27692(class_124.field_1061), player);
        }
    }

    public void updateColorHovered(boolean hovered, class_746 player, NotificationContext notification) {
        COLOR_HOVERED = hovered;
        try {
            HighlightItem.configurator.updateConfig(Config.COLOR_HOVERED, "" + COLOR_HOVERED);
            this.notify(notification, (class_2561)(COLOR_HOVERED ? class_2561.method_43471((String)"notification.highlightitem.color_hovered_activated").method_27692(class_124.field_1080) : class_2561.method_43471((String)"notification.highlightitem.color_hovered_deactivated").method_27692(class_124.field_1063)), player);
        }
        catch (IOException e) {
            this.notify(notification, (class_2561)class_2561.method_43471((String)"notification.highlightitem.config.update.fail").method_27692(class_124.field_1061), player);
        }
    }

    public void changeMode(class_746 player, NotificationContext notification) {
        if (COMPARATOR.ordinal() == ItemComparator.Comparators.values().length - 1) {
            HighlightItem.configurator.updateMode(ItemComparator.Comparators.ITEM_ONLY, player, notification);
        } else {
            for (ItemComparator.Comparators mode : ItemComparator.Comparators.values()) {
                if (mode.ordinal() != Math.min(COMPARATOR.ordinal() + 1, ItemComparator.Comparators.values().length - 1)) continue;
                HighlightItem.configurator.updateMode(mode, player, notification);
                break;
            }
        }
    }

    public void updateMode(ItemComparator.Comparators mode, class_746 player, NotificationContext notification) {
        COMPARATOR = mode;
        try {
            HighlightItem.configurator.updateConfig(Config.COMPARATOR, mode.name());
            this.notify(notification, (class_2561)class_2561.method_43469((String)"notification.highlightitem.comparator.change", (Object[])new Object[]{class_2561.method_43471((String)mode.translationKey()).method_27693(" (").method_27693(mode.name()).method_27693(")")}).method_27692(class_124.field_1080), player);
        }
        catch (IOException e) {
            this.notify(notification, (class_2561)class_2561.method_43471((String)"notification.highlightitem.config.update.fail").method_27692(class_124.field_1061), player);
        }
    }

    public void updateColor(float[] rgba, @Nullable class_746 player) {
        block3: {
            COLOR = class_9848.method_61324((int)((int)(rgba[3] * 255.0f)), (int)((int)(rgba[0] * 255.0f)), (int)((int)(rgba[1] * 255.0f)), (int)((int)(rgba[2] * 255.0f)));
            try {
                HighlightItem.configurator.updateConfig(Config.COLOR, Colors.customToJson(rgba).toString());
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"notification.highlightitem.color").method_27692(class_124.field_1080), false);
                }
            }
            catch (IOException e) {
                if (player == null) break block3;
                player.method_7353((class_2561)class_2561.method_43471((String)"notification.highlightitem.config.update.fail").method_27692(class_124.field_1061), false);
            }
        }
    }

    public void updateNotificationPreference(NotificationPreference notificationPreference) {
        NOTIFICATION_PREFERENCE = notificationPreference;
        try {
            HighlightItem.configurator.updateConfig(Config.NOTIFICATION_PREFERENCE, notificationPreference.name());
        }
        catch (IOException e) {
            this.notifyToast((class_2561)class_2561.method_43471((String)"notification.highlightitem.config.update.fail").method_27692(class_124.field_1061));
        }
    }

    private void notify(NotificationContext type, class_2561 text, @Nullable class_746 player) {
        if (type.equals((Object)NotificationContext.ON_SCREEN) || NOTIFICATION_PREFERENCE.equals((Object)NotificationPreference.TOAST)) {
            this.notifyToast(text);
            return;
        }
        if (player == null) {
            return;
        }
        if (NOTIFICATION_PREFERENCE.equals((Object)NotificationPreference.CHAT)) {
            player.method_7353(text, false);
            return;
        }
        if (NOTIFICATION_PREFERENCE.equals((Object)NotificationPreference.OVERLAY)) {
            player.method_7353(text, true);
            return;
        }
        switch (type.ordinal()) {
            case 2: {
                player.method_7353(text, false);
                break;
            }
            case 3: {
                player.method_7353(text, true);
            }
        }
    }

    private void notifyToast(class_2561 text) {
        this.notifyToast((class_2561)class_2561.method_43470((String)"HighLightItem"), text);
    }

    private void notifyToast(class_2561 text, class_2561 desc) {
        if (activeToastNotification == null || activeToastNotification.method_61988().equals((Object)class_368.class_369.field_2209)) {
            activeToastNotification = new class_370(class_370.class_9037.field_47588, text, desc);
            class_310.method_1551().method_1566().method_1999((class_368)activeToastNotification);
        } else {
            activeToastNotification.method_1991(text, desc);
            ((SystemToastAccessor)activeToastNotification).setWidth(Math.max(200, class_310.method_1551().field_1772.method_1728((class_5348)desc, 200).stream().mapToInt(value -> class_310.method_1551().field_1772.method_27525((class_5348)desc)).max().orElse(200)) + 30);
            activeToastNotification.method_61989(class_310.method_1551().method_1566(), 5000L);
        }
    }

    static {
        activeToastNotification = null;
    }

    public static enum Config {
        COLOR("color", Colors.HighLightColor.DEFAULT.json().toString()),
        COLOR_HOVERED("color-hovered", "false"),
        TOGGLE("toggle", "true"),
        COMPARATOR("comparator", ItemComparator.Comparators.ITEM_ONLY.name()),
        NOTIFICATION_PREFERENCE("notif-preference", NotificationPreference.NONE.name());

        private final String key;
        private final String def;

        private Config(String key, String def) {
            this.key = key;
            this.def = def;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefault() {
            return this.def;
        }
    }

    public static enum NotificationPreference implements class_7291
    {
        NONE,
        TOAST,
        CHAT,
        OVERLAY;


        public int method_7362() {
            return this.ordinal();
        }

        public String method_7359() {
            return "options.highlightitem.notif." + this.name().toLowerCase();
        }
    }

    public static enum NotificationContext {
        NONE,
        ON_SCREEN,
        SENDING_COMMAND,
        IN_GAME;

    }
}

