/*
 * Decompiled with CFR 0.152.
 */
package de.tert0.msmpenhanced;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.tert0.msmpenhanced.MsmpEnhancedMod;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_11341;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record Config(boolean unixSocketEnabled, @NotNull String unixSocketPath) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("unixSocketEnabled").forGetter(Config::unixSocketEnabled), (App)Codec.STRING.fieldOf("unixSocketPath").forGetter(Config::unixSocketPath)).apply((Applicative)instance, Config::new));
    private static final Config DEFAULT = new Config(false, "msmp.sock");

    public static Config load(Path configPath) {
        File file = configPath.toFile();
        Config config = DEFAULT;
        if (file.exists()) {
            try {
                DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)class_11341.method_71360((String)Files.readString(configPath)));
                config = (Config)result.resultOrPartial(arg_0 -> ((Logger)MsmpEnhancedMod.LOGGER).error(arg_0)).orElseThrow();
            }
            catch (IOException e) {
                MsmpEnhancedMod.LOGGER.error("Failed to load config file", (Throwable)e);
            }
        } else if (file.getParentFile().canWrite() || file.canWrite()) {
            DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT);
            JsonElement json = (JsonElement)result.getOrThrow();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(json, GSON.newJsonWriter((Writer)writer));
            }
            catch (IOException e) {
                MsmpEnhancedMod.LOGGER.error("Failed to write default config file", (Throwable)e);
            }
        } else {
            MsmpEnhancedMod.LOGGER.info("Config at {} is not writable. Using default config.", (Object)configPath);
        }
        if (config.unixSocketEnabled && config.unixSocketPath.isEmpty()) {
            throw new IllegalArgumentException("Empty unix socket path");
        }
        return config;
    }
}

