/*
 * Decompiled with CFR 0.152.
 */
package org.karlssonsmp.phantomLimiter;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.karlssonsmp.phantomlimiter.bstats.bukkit.Metrics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/karlssonsmp/phantomLimiter/PhantomLimiter;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "spawnRate", "", "prefix", "", "onEnable", "", "onDisable", "onPhantomSpawn", "event", "Lorg/bukkit/event/entity/CreatureSpawnEvent;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "PhantomLimiter"})
public final class PhantomLimiter
extends JavaPlugin
implements Listener {
    private volatile double spawnRate = 0.25;
    @NotNull
    private final String prefix;

    public PhantomLimiter() {
        this.prefix = "\u00a79\u00a7l\u1d18\u029c\u1d00\u0274\u1d1b\u1d0f\u1d0d\u029f\u026a\u1d0d\u026a\u1d1b\u1d07\u0280 \u00a77\u00bb \u00a7r";
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.spawnRate = RangesKt.coerceIn(this.getConfig().getDouble("phantom-spawn-rate", 0.25), 0.0, 1.0);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 26883;
        new Metrics(this, pluginId);
        this.getLogger().info("PhantomLimiter enabled! Phantom spawn rate set to " + (int)(this.spawnRate * (double)100) + "%.");
    }

    public void onDisable() {
        this.getLogger().info("PhantomLimiter disabled!");
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public final void onPhantomSpawn(@NotNull CreatureSpawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntityType() != EntityType.PHANTOM) {
            return;
        }
        CreatureSpawnEvent.SpawnReason[] spawnReasonArray = new CreatureSpawnEvent.SpawnReason[]{CreatureSpawnEvent.SpawnReason.NATURAL, CreatureSpawnEvent.SpawnReason.PATROL};
        Set<CreatureSpawnEvent.SpawnReason> validReasons = SetsKt.setOf(spawnReasonArray);
        if (!validReasons.contains(event.getSpawnReason())) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.spawnRate) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (StringsKt.equals(command.getName(), "phantomlimiter", true)) {
            if (!(args2.length == 0) && StringsKt.equals(args2[0], "reload", true)) {
                if (!sender.hasPermission("phantomlimiter.reload")) {
                    sender.sendMessage(this.prefix + "\u00a7cYou don't have permission to do that.");
                    return true;
                }
                this.reloadConfig();
                this.spawnRate = RangesKt.coerceIn(this.getConfig().getDouble("phantom-spawn-rate", 0.25), 0.0, 1.0);
                sender.sendMessage(this.prefix + "\u00a7aConfig reloaded! Spawn rate: " + (int)(this.spawnRate * (double)100) + '%');
                return true;
            }
            sender.sendMessage(this.prefix + "\u00a77Usage: /phantomlimiter reload");
            return true;
        }
        return false;
    }
}

