/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import java.util.Optional;
import java.util.function.Predicate;
import mypals.ml.command.CommandRegister;
import mypals.ml.config.Keybinds;
import mypals.ml.config.LucidityConfig;
import mypals.ml.config.ScreenGenerator;
import mypals.ml.features.ImageRendering.ImageDataParser;
import mypals.ml.features.ImageRendering.configuration.ImageConfigCommands;
import mypals.ml.features.OreFinder.MineralFinder;
import mypals.ml.features.OreFinder.OreResolver;
import mypals.ml.features.advancedAdvancedTooltip.AdvancedAdvancedToolTip;
import mypals.ml.features.arrowCamera.ArrowCamera;
import mypals.ml.features.betterBarrier.BetterBarrier;
import mypals.ml.features.commandHelper.ChatCommandScreenObserver;
import mypals.ml.features.damageIndicator.DamageHandler;
import mypals.ml.features.damageIndicator.IndicatorRenderer;
import mypals.ml.features.explosionVisualizer.ExplosionVisualizer;
import mypals.ml.features.highLightFluidSource.FluidSourceResourceLoader;
import mypals.ml.features.mobFollowRange.MobFollowRangeScanner;
import mypals.ml.features.pastBlockEvents.ClientsideBlockEventManager;
import mypals.ml.features.renderKeyPresses.KeyPressesManager;
import mypals.ml.features.renderMobSpawn.SpaceScanner;
import mypals.ml.features.safeDigging.DiggingSituationResolver;
import mypals.ml.features.selectiveRendering.SelectiveRenderingManager;
import mypals.ml.features.selectiveRendering.WandActionsManager;
import mypals.ml.features.selectiveRendering.WandTooltipRenderer;
import mypals.ml.features.sonicBoomDetection.WardenStateResolver;
import mypals.ml.features.soundListener3D.SoundListener;
import mypals.ml.features.trajectory.TrajectoryManager;
import mypals.ml.rendering.InformationRender;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11515;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_7172;
import net.minecraft.class_7260;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lucidity
implements ModInitializer {
    private static final SoundListener soundListener = new SoundListener();
    public static final String MOD_ID = "lucidity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"lucidity");
    public static final class_7172<Double> GAMMA_BYPASS = new class_7172("options.gamma", class_7172.method_42399(), (optionText, value) -> class_2561.method_43473(), (class_7172.class_7178)class_7172.class_7177.field_37875.method_42420(d -> 40.0, d -> 1.0), (Object)40.0, value -> {});

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void onConfigUpdated() {
        class_310 client = class_310.method_1551();
        Lucidity.updateChunks(client);
        if (!LucidityConfig.enableWorldEaterHelper.booleanValue()) {
            OreResolver.recordedOres.clear();
        } else if (class_310.method_1551().field_1724 != null) {
            MineralFinder.iterateBlocksWithinDistance(class_310.method_1551().field_1724.method_24515(), LucidityConfig.oreHighlightRange);
        }
        try {
            Lucidity.updateConfig();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            e.printStackTrace();
        }
    }

    private static void resolveSettings() {
        SelectiveRenderingManager.resolveSelectedBlockStatesFromString(LucidityConfig.selectedBlockTypes);
        SelectiveRenderingManager.resolveSelectedEntityTypesFromString(LucidityConfig.selectedEntityTypes);
        SelectiveRenderingManager.resolveSelectedParticleTypesFromString(LucidityConfig.selectedParticleTypes);
        MineralFinder.parseSelectedBlocks();
        ImageDataParser.prepareImages();
        SelectiveRenderingManager.resolveSelectedAreasFromString(LucidityConfig.selectedAreasSaved);
        SelectiveRenderingManager.resolveSelectedWandFromString(LucidityConfig.wand);
        if (SelectiveRenderingManager.blockRenderMode.equals((Object)SelectiveRenderingManager.RenderMode.OFF) && class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_6016(class_1294.field_5925);
        }
    }

    public static void updateChunks(class_310 client) {
        client.field_1769.method_3279();
    }

    public static void updateConfig() {
        ConfigClassHandler<LucidityConfig> instance = LucidityConfig.CONFIG_HANDLER;
        instance.load();
        ExplosionVisualizer.FixRangeIssue();
        LucidityConfig.CONFIG_HANDLER.instance();
        Lucidity.resolveSettings();
    }

    public void onInitialize() {
        BetterBarrier.init();
        class_7923.field_41173.forEach(fluid -> BlockRenderLayerMap.putFluid((class_3611)fluid, (class_11515)class_11515.field_60926));
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"lavahighlight"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        ImageConfigCommands.register();
        CommandRegister.registerCommands();
        TrajectoryManager.init();
        new SoundListener();
        new ArrowCamera();
        AdvancedAdvancedToolTip.onInitialize();
        SelectiveRenderingManager.resolveSelectiveBlockRenderingMode(LucidityConfig.renderModeBlock);
        SelectiveRenderingManager.resolveSelectiveEntityRenderingMode(LucidityConfig.renderModeEntity);
        SelectiveRenderingManager.resolveSelectiveParticleRenderingMode(LucidityConfig.renderModeParticle);
        FluidSourceResourceLoader.init();
        Keybinds.init();
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            KeyPressesManager.renderPressed(context);
            WandTooltipRenderer.renderWandTooltip(context);
            IndicatorRenderer.renderIndicators(context);
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> Lucidity.updateConfig());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            InformationRender.clear();
            WandActionsManager.wandActions(client);
            Lucidity.resolveEnviroment(client);
            Lucidity.resolveEntities(client, 50);
            Lucidity.UpdateTimers();
            if (Keybinds.openConfigKey.method_1436()) {
                this.openConfigScreen(client);
            }
            if (Keybinds.openImageRenderingsConfigKey.method_1436()) {
                ImageConfigCommands.openImageRenderingConfigGUI("image renderings");
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(t -> Lucidity.extraActions());
        UseBlockCallback.EVENT.register((player, world, hand, pos) -> {
            DiggingSituationResolver.warningTime = DiggingSituationResolver.WARNING_TIME;
            if (world.field_9236 && player.method_5998(hand).method_7909() == SelectiveRenderingManager.wand && player.method_68878()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, dir) -> {
            DiggingSituationResolver.warningTime = DiggingSituationResolver.WARNING_TIME;
            if (world.field_9236 && player.method_5998(hand).method_7909() == SelectiveRenderingManager.wand && player.method_68878()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    private void openConfigScreen(class_310 client) {
        client.execute(() -> {
            if (client.field_1755 == null) {
                client.method_1507(ScreenGenerator.getConfigScreen(client.field_1755));
            }
        });
    }

    private static void extraActions() {
        LucidityConfig.CONFIG_HANDLER.instance();
        if (!SelectiveRenderingManager.blockRenderMode.equals((Object)SelectiveRenderingManager.RenderMode.OFF) && class_310.method_1551().field_1724 != null && LucidityConfig.autoNightVision) {
            class_310.method_1551().field_1724.method_6092(new class_1293(class_1294.field_5925, 10000, 5, true, false, false));
        }
    }

    private static void resolveEntities(class_310 client, int scanRadius) {
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        assert (client.field_1724 != null);
        if (LucidityConfig.renderWardenAttackRange) {
            class_238 searchBox = new class_238(client.field_1724.method_23317() - (double)scanRadius, client.field_1724.method_23318() - (double)scanRadius, client.field_1724.method_23321() - (double)scanRadius, client.field_1724.method_23317() + (double)scanRadius, client.field_1724.method_23318() + (double)scanRadius, client.field_1724.method_23321() + (double)scanRadius);
            world.method_8390(class_7260.class, searchBox, warden -> true).forEach(WardenStateResolver::resolveWardenState);
        }
        if (LucidityConfig.renderMobChaseRange || LucidityConfig.renderMobEyeLineConnection) {
            MobFollowRangeScanner.onClientTick(scanRadius);
        }
    }

    private static void resolveEnviroment(class_310 client) {
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        assert (client.field_1724 != null);
        class_746 player = client.field_1724;
        if (LucidityConfig.betterLight || LucidityConfig.betterBarrier || LucidityConfig.betterStructureVoid) {
            BetterBarrier.checkForBetterRenderersEnabled();
        }
        if (DiggingSituationResolver.warningTime > 0) {
            class_3965 class_39652 = Lucidity.getPlayerLookedBlock((class_1657)player, (class_1937)world);
        }
        if (LucidityConfig.enableDamageIndicator) {
            DamageHandler.PlayerHealthMonitor();
        }
        if (LucidityConfig.renderTrajectory) {
            TrajectoryManager.onClientTick(client);
        }
        if (LucidityConfig.renderMobSpawn) {
            SpaceScanner.addSpawnDataToInformationRenderer();
        }
        if (LucidityConfig.enableExplosionVisualizer) {
            ExplosionVisualizer.tick(client);
        }
        if (LucidityConfig.enableWorldEaterHelper.booleanValue()) {
            OreResolver.onClientTick();
        }
        if (LucidityConfig.commandHelper) {
            ChatCommandScreenObserver.onClientTick();
        }
        if (LucidityConfig.arrowcam) {
            ArrowCamera.onClientTick();
        }
        soundListener.onClientTick();
        if (LucidityConfig.renderBlockEvents) {
            ClientsideBlockEventManager.onClientTick();
        }
        ImageDataParser.onClientTick();
    }

    public static void UpdateTimers() {
        DiggingSituationResolver.warningTime = DiggingSituationResolver.warningTime <= 0 ? 0 : DiggingSituationResolver.warningTime - 1;
        WandActionsManager.selectCoolDown = WandActionsManager.selectCoolDown <= 0 ? 0 : WandActionsManager.selectCoolDown - 1;
    }

    public static class_3965 getPlayerLookedBlock(class_1657 player, class_1937 world) {
        class_1297 camera = class_310.method_1551().method_1560();
        class_243 start = camera.method_5836(1.0f);
        class_243 end = start.method_1019(camera.method_5828(1.0f).method_1021(player.method_68878() ? 5.0 : 4.0));
        class_3959 context = new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
        return world.method_17742(context);
    }

    public static class_3966 getPlayerLookedEntity(class_1657 player, class_1937 world) {
        class_1297 camera = class_310.method_1551().method_1560();
        class_243 start = camera.method_5836(1.0f);
        class_243 end = start.method_1019(camera.method_5828(1.0f).method_1021(player.method_68878() ? 5.0 : 4.0));
        class_238 box = player.method_5829().method_18804(end.method_1020(start)).method_1014(1.0);
        class_3966 result = Lucidity.getEntityCollision(world, (class_1297)player, start, end, box, entity -> entity != player, 0.5f);
        return result;
    }

    public static class_3966 getEntityCollision(class_1937 world, class_1297 entity, class_243 min, class_243 max, class_238 box, Predicate<class_1297> predicate, float margin) {
        double closestDistance = Double.MAX_VALUE;
        class_1297 closestEntity = null;
        for (class_1297 target : world.method_8333(entity, box, predicate)) {
            double distance;
            class_238 expandedBox = target.method_5829().method_1014((double)margin);
            Optional hitPos = expandedBox.method_992(min, max);
            if (!hitPos.isPresent() || !((distance = min.method_1025((class_243)hitPos.get())) < closestDistance)) continue;
            closestEntity = target;
            closestDistance = distance;
        }
        return closestEntity == null ? null : new class_3966(closestEntity);
    }
}

