/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.command.lib;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class CommandBuilder<S extends class_2172> {
    private LiteralArgumentBuilder<S> root;
    private LiteralArgumentBuilder<S> commandNode;
    private final List<String> argumentNames = new ArrayList<String>();
    private final List<ArgumentType<?>> argumentTypes = new ArrayList();
    private final List<Class<?>> argumentClasses = new ArrayList();
    private final EnvType environment;
    private String rootName;
    private String feedbackMessage;
    private class_124 feedbackColor = class_124.field_1068;

    private CommandBuilder(String name, EnvType environment) {
        this.environment = environment;
        this.rootName = name;
        this.root = environment == EnvType.CLIENT ? ClientCommandManager.literal((String)name) : class_2170.method_9247((String)name);
        this.commandNode = this.root;
    }

    public static CommandBuilder<FabricClientCommandSource> clientCommand(String name) {
        return new CommandBuilder<FabricClientCommandSource>(name, EnvType.CLIENT);
    }

    public static CommandBuilder<class_2168> serverCommand(String name) {
        return new CommandBuilder<class_2168>(name, EnvType.SERVER);
    }

    public CommandBuilder<S> root(String rootName) {
        this.rootName = rootName;
        LiteralArgumentBuilder newRoot = this.environment == EnvType.CLIENT ? ClientCommandManager.literal((String)rootName) : class_2170.method_9247((String)rootName);
        this.root = newRoot;
        this.commandNode = ClientCommandManager.literal((String)this.rootName);
        this.root.then(this.commandNode);
        return this;
    }

    public <T> CommandBuilder<S> argument(String name, ArgumentType<T> type, Class<T> clazz) {
        this.argumentNames.add(name);
        this.argumentTypes.add(type);
        this.argumentClasses.add(clazz);
        return this;
    }

    public CommandBuilder<S> execute(Consumer<Object[]> action) {
        if (this.argumentNames.isEmpty()) {
            this.commandNode.executes(ctx -> this.executeCommand(ctx, action, 0));
        } else {
            ArgumentBuilder argBuilder = this.commandNode;
            for (int i = 0; i < this.argumentNames.size(); ++i) {
                int finalI = i;
                argBuilder = argBuilder.then(class_2170.method_9244((String)this.argumentNames.get(i), this.argumentTypes.get(i)).executes(ctx -> this.executeCommand(ctx, action, finalI + 1)));
            }
            this.commandNode.then(argBuilder);
        }
        return this;
    }

    public CommandBuilder<S> feedBack(String message, class_124 color) {
        this.feedbackMessage = message;
        this.feedbackColor = color;
        return this;
    }

    private int executeCommand(CommandContext<?> ctx, Consumer<Object[]> action, int argCount) {
        class_746 player;
        Object[] args = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = ctx.getArgument(this.argumentNames.get(i), this.argumentClasses.get(i));
        }
        action.accept(args);
        if (this.environment == EnvType.CLIENT && (player = class_310.method_1551().field_1724) != null && this.feedbackMessage != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)this.feedbackMessage).method_27692(this.feedbackColor), false);
        }
        return 1;
    }

    public void register() {
        if (this.environment == EnvType.CLIENT) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(this.root));
        } else {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, env) -> {
                if (env.field_25423) {
                    dispatcher.register(this.root);
                }
            });
        }
    }
}

