/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.ImageRendering;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import mypals.ml.Lucidity;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.ImageRendering.GIFHandler;
import mypals.ml.features.ImageRendering.ITextureManagerMixin;
import mypals.ml.features.ImageRendering.MediaTypeDetector;
import mypals.ml.features.ImageRendering.configuration.ImageConfigScreen;
import mypals.ml.features.ImageRendering.configuration.MediaEntry;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class ImageDataParser {
    public static final String TEMP_TEXTURE_PATH = "textures/temp/";
    private static final String GENERATED_PATH = "assets/lucidity/textures/generated/";
    public static final class_2960 LOST = class_2960.method_60655((String)"lucidity", (String)"textures/lost-file.png");
    public static final class_2960 LOADING = class_2960.method_60655((String)"lucidity", (String)"textures/loading.png");
    public static ArrayList<MediaEntry> readyToMerge = new ArrayList();
    public static ConcurrentHashMap<String, MediaEntry> images = new ConcurrentHashMap();

    public static void onClientTick() {
        ImageDataParser.mergeImages();
    }

    public static void prepareImages() {
        class_310 client = class_310.method_1551();
        class_1060 textureManager = client.method_1531();
        ((ITextureManagerMixin)textureManager).lucidity$destroyAll(class_2960.method_60655((String)"lucidity", (String)TEMP_TEXTURE_PATH));
        images.clear();
        for (int i = 0; i < LucidityConfig.picturesToRender.size(); ++i) {
            String pic = LucidityConfig.picturesToRender.get(i);
            ImageDataParser.resolveRepeatedName(i);
            ImageDataParser.putToImages(ImageDataParser.parse(pic, i));
        }
    }

    public static void putToImages(MediaEntry mediaEntry) {
        if (mediaEntry != null) {
            images.put(mediaEntry.getName(), mediaEntry);
        }
    }

    public static void mergeImages() {
        for (MediaEntry image : readyToMerge) {
            images.put(image.getName(), image);
        }
        readyToMerge.clear();
    }

    public static class_2960 prepareImageMedia(String path, String name) {
        return ImageDataParser.createTexture(path, name);
    }

    public static Map.Entry<class_2960[], List<Integer>> prepareGIFMedia(String path, String name) {
        GIFHandler.GifFrameData data = GIFHandler.createGifTextures(path, name);
        return Map.entry((class_2960[])data.identifiers.toArray(class_2960[]::new), data.delays);
    }

    public static void resolveRepeatedName(int index) {
        String picture = LucidityConfig.picturesToRender.get(index);
        String[] parts = picture.split(";");
        String oldName = parts[1];
        if (images.get(oldName) != null) {
            String newName = oldName + "_";
            String newPath = parts[0] + ";" + newName + ";" + parts[2] + ";" + parts[3] + ";" + parts[4];
            ImageDataParser.changeMapKey(images, oldName, newName);
            LucidityConfig.picturesToRender.set(index, newPath);
            LucidityConfig.CONFIG_HANDLER.save();
        }
    }

    public static <K, V> void changeMapKey(Map<K, V> map, K oldKey, K newKey) {
        if (map.containsKey(oldKey)) {
            V value = map.remove(oldKey);
            map.put(newKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_2960 createTexture(String source, String name) {
        class_310 client = class_310.method_1551();
        class_1060 textureManager = client.method_1531();
        class_2960 generatedPath = LOST;
        class_1011 image = null;
        try {
            block20: {
                if (source.startsWith("http://") || source.startsWith("https://")) {
                    URL imageUrl = new URL(source);
                    HttpURLConnection connection = (HttpURLConnection)imageUrl.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    connection.setConnectTimeout(5000);
                    String contentType = connection.getContentType();
                    if (contentType == null || !contentType.toLowerCase().startsWith("image/")) {
                        Lucidity.LOGGER.warn("URL {} does not point to an image (Content-Type: {})", (Object)source, (Object)contentType);
                        connection.disconnect();
                        return generatedPath;
                    }
                    try (InputStream inputStream = connection.getInputStream();){
                        image = ImageDataParser.convertToNativeImage(inputStream);
                        break block20;
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                File file = new File(source);
                if (!file.exists() || !file.isFile()) {
                    Lucidity.LOGGER.warn("File {} does not exist or is not a file", (Object)source);
                    return generatedPath;
                }
                try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    image = ImageDataParser.convertToNativeImage(inputStream);
                }
            }
            class_2960 finalGeneratedPath = generatedPath = class_2960.method_60655((String)"lucidity", (String)(TEMP_TEXTURE_PATH + name));
            class_1011 finalImage = image;
            class_2960 finalGeneratedPath1 = generatedPath;
            class_310.method_1551().execute(() -> textureManager.method_4616(finalGeneratedPath, (class_1044)new class_1043(() -> ((class_2960)finalGeneratedPath1).method_42094(), finalImage)));
        }
        catch (IOException e) {
            Lucidity.LOGGER.error("Failed to create texture from {}: {}", (Object)source, (Object)e.getMessage());
            e.printStackTrace();
            Map.entry(null, generatedPath);
        }
        return generatedPath;
    }

    public static class_2960 requestIdentifier(MediaEntry mediaEntry) {
        if (mediaEntry == null) {
            return LOST;
        }
        if (mediaEntry.getType().equals((Object)MediaTypeDetector.MediaType.IMAGE)) {
            return mediaEntry.isReady() ? mediaEntry.getTexture()[0] : LOADING;
        }
        if (mediaEntry.getType().equals((Object)MediaTypeDetector.MediaType.GIF)) {
            if (!mediaEntry.isReady()) {
                return LOADING;
            }
            List<class_2960> textures = List.of(mediaEntry.getTexture());
            List<Integer> delays = mediaEntry.getDelays();
            if (delays == null || textures.isEmpty()) {
                return LOADING;
            }
            int totalDuration = delays.stream().mapToInt(Integer::intValue).sum();
            if (totalDuration == 0) {
                return textures.get(0);
            }
            long currentTime = System.currentTimeMillis();
            long timeInCycle = currentTime % (long)totalDuration;
            int elapsed = 0;
            try {
                for (int i = 0; i < delays.size(); ++i) {
                    if (timeInCycle >= (long)(elapsed += delays.get(i).intValue())) continue;
                    return textures.get(i);
                }
            }
            catch (Exception e) {
                Lucidity.LOGGER.error("Error while calculating GIF frame: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
            return textures.get(0);
        }
        return mediaEntry.isReady() ? mediaEntry.getTexture()[0] : LOADING;
    }

    private static class_1011 convertToNativeImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            throw new IOException("Unable to decode image");
        }
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", pngOutputStream);
        byte[] pngBytes = pngOutputStream.toByteArray();
        try (ByteArrayInputStream pngInputStream = new ByteArrayInputStream(pngBytes);){
            class_1011 class_10112 = class_1011.method_4309((InputStream)pngInputStream);
            return class_10112;
        }
    }

    private static double[] parseArray(String arrayString, int expectCount) {
        String[] elements = arrayString.replaceAll("[\\[\\]]", "").split(",");
        return Arrays.copyOf(Arrays.stream(elements).mapToDouble(Double::parseDouble).toArray(), expectCount);
    }

    public static MediaEntry parse(String picture, int index) {
        String[] parts = picture.split(";");
        if (parts.length < 5) {
            return null;
        }
        String path = parts[0];
        String name = parts[1];
        double[] pos = ImageDataParser.parseArray(parts[2], 3);
        double[] rotation = ImageDataParser.parseArray(parts[3], 3);
        double[] scale = ImageDataParser.parseArray(parts[4], 2);
        MediaEntry initialEntry = new MediaEntry(false, index, name, path, new class_2960[]{LOADING}, pos, rotation, scale, MediaTypeDetector.MediaType.UNKNOWN){

            @Override
            protected void onClicked(ImageConfigScreen imageConfigScreen) {
                if (imageConfigScreen != null) {
                    imageConfigScreen.currentImage = this;
                    this.setSelected(true);
                    imageConfigScreen.scaleXF.field_22763 = true;
                    imageConfigScreen.scaleYF.field_22763 = true;
                    imageConfigScreen.posXF.field_22763 = true;
                    imageConfigScreen.posYF.field_22763 = true;
                    imageConfigScreen.posZF.field_22763 = true;
                    imageConfigScreen.rotXF.field_22763 = true;
                    imageConfigScreen.rotYF.field_22763 = true;
                    imageConfigScreen.rotZF.field_22763 = true;
                    imageConfigScreen.nameF.field_22763 = true;
                    imageConfigScreen.cancelButton.field_22763 = true;
                    imageConfigScreen.saveButton.field_22763 = true;
                    imageConfigScreen.moveToPlayerButton.field_22763 = true;
                    imageConfigScreen.lookAtPlayerButton.field_22763 = true;
                    imageConfigScreen.pathF.method_1852(this.getPath());
                    imageConfigScreen.rotXF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[0]))));
                    imageConfigScreen.rotYF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[1]))));
                    imageConfigScreen.rotZF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[2]))));
                    imageConfigScreen.scaleXF.method_1852(String.valueOf(this.getScale()[0]));
                    imageConfigScreen.scaleYF.method_1852(String.valueOf(this.getScale()[1]));
                    imageConfigScreen.posXF.method_1852(String.valueOf(this.getPos()[0]));
                    imageConfigScreen.posYF.method_1852(String.valueOf(this.getPos()[1]));
                    imageConfigScreen.posZF.method_1852(String.valueOf(this.getPos()[2]));
                    imageConfigScreen.nameF.method_1852(this.name);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
            }
        };
        new Thread(() -> {
            try {
                class_2960[] image = new class_2960[]{LOST};
                List<Object> delays = new ArrayList();
                MediaTypeDetector.MediaType type = MediaTypeDetector.detectMediaType(path);
                if (type.equals((Object)MediaTypeDetector.MediaType.IMAGE)) {
                    image = new class_2960[]{ImageDataParser.prepareImageMedia(path, name)};
                }
                if (type.equals((Object)MediaTypeDetector.MediaType.GIF)) {
                    Map.Entry<class_2960[], List<Integer>> gifEntry = ImageDataParser.prepareGIFMedia(path, name);
                    image = gifEntry.getKey();
                    delays = gifEntry.getValue();
                }
                MediaEntry finalEntry = new MediaEntry(true, index, name, path, image, pos, rotation, scale, type){

                    @Override
                    protected void onClicked(ImageConfigScreen imageConfigScreen) {
                        if (imageConfigScreen != null) {
                            imageConfigScreen.currentImage = this;
                            this.setSelected(true);
                            imageConfigScreen.scaleXF.field_22763 = true;
                            imageConfigScreen.scaleYF.field_22763 = true;
                            imageConfigScreen.posXF.field_22763 = true;
                            imageConfigScreen.posYF.field_22763 = true;
                            imageConfigScreen.posZF.field_22763 = true;
                            imageConfigScreen.rotXF.field_22763 = true;
                            imageConfigScreen.rotYF.field_22763 = true;
                            imageConfigScreen.rotZF.field_22763 = true;
                            imageConfigScreen.nameF.field_22763 = true;
                            imageConfigScreen.cancelButton.field_22763 = true;
                            imageConfigScreen.saveButton.field_22763 = true;
                            imageConfigScreen.moveToPlayerButton.field_22763 = true;
                            imageConfigScreen.lookAtPlayerButton.field_22763 = true;
                            imageConfigScreen.pathF.method_1852(this.getPath());
                            imageConfigScreen.rotXF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[0]))));
                            imageConfigScreen.rotYF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[1]))));
                            imageConfigScreen.rotZF.method_25347(ImageConfigScreen.mapToZeroOne(Double.parseDouble(String.valueOf(this.getRotation()[2]))));
                            imageConfigScreen.scaleXF.method_1852(String.valueOf(this.getScale()[0]));
                            imageConfigScreen.scaleYF.method_1852(String.valueOf(this.getScale()[1]));
                            imageConfigScreen.posXF.method_1852(String.valueOf(this.getPos()[0]));
                            imageConfigScreen.posYF.method_1852(String.valueOf(this.getPos()[1]));
                            imageConfigScreen.posZF.method_1852(String.valueOf(this.getPos()[2]));
                            imageConfigScreen.nameF.method_1852(this.name);
                            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                        }
                    }
                };
                if (delays.size() > 0) {
                    finalEntry.setDelays(delays);
                }
                images.put(finalEntry.getName(), finalEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        return initialEntry;
    }

    public static Vector2d toBlockScale(float ppb, Vector2d scale, Vector2i size) {
        double blocksX = (double)size.x * scale.x / (double)ppb;
        double blocksY = (double)size.y * scale.y / (double)ppb;
        return new Vector2d(blocksX, blocksY);
    }

    public static class ImageData {
        public int index;
        public String path;
        public String name;
        public double[] pos;
        public double[] rotation;
        public double[] scale;

        public ImageData(int index, String path, String name, double[] pos, double[] rotation, double[] scale) {
            this.index = index;
            this.path = path;
            this.name = name;
            this.pos = pos;
            this.rotation = rotation;
            this.scale = scale;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public double[] getPos() {
            return this.pos;
        }

        public int getIndex() {
            return this.index;
        }

        public double[] getRotation() {
            return this.rotation;
        }

        public double[] getScale() {
            return this.scale;
        }

        public String toString() {
            return String.format("%s;%s;%s;%s;%s", this.path, this.name, Arrays.toString(this.pos), Arrays.toString(this.rotation), Arrays.toString(this.scale));
        }
    }
}

