/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.ImageRendering;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import mypals.ml.features.ImageRendering.ImageDataParser;
import mypals.ml.features.ImageRendering.configuration.MediaEntry;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4668;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2d;

public class ImageRenderer {
    private static final Function<class_2960, class_1921> IMAGE;
    public static final RenderPipeline GUI_TEXTURED_ALPHA;

    public static void renderPictureWorldSpace(class_4587 matrixStack, class_2960 textureId, class_243 pos, class_243 rotation, Vector2d scale, float pixelsPerBlock, int light, int overlay, float tickDelta, boolean disableDepthTest) throws IOException {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.field_1724 == null) {
            return;
        }
        double lastTickPosX = camera.method_19326().method_10216();
        double lastTickPosY = camera.method_19326().method_10214();
        double lastTickPosZ = camera.method_19326().method_10215();
        float x = (float)(pos.method_10216() - class_3532.method_16436((double)tickDelta, (double)lastTickPosX, (double)camera.method_19326().method_10216()));
        float y = (float)(pos.method_10214() - class_3532.method_16436((double)tickDelta, (double)lastTickPosY, (double)camera.method_19326().method_10214()));
        float z = (float)(pos.method_10215() - class_3532.method_16436((double)tickDelta, (double)lastTickPosZ, (double)camera.method_19326().method_10215()));
        ImageRenderer.renderPicture(matrixStack, textureId, new class_243((double)x, (double)y, (double)z), rotation, scale, pixelsPerBlock, light, overlay, tickDelta, disableDepthTest);
    }

    public static void renderPictureWorldSpace(class_4587 matrixStack, MediaEntry mediaEntry, class_243 pos, class_243 rotation, Vector2d scale, float pixelsPerBlock, int light, int overlay, float tickDelta, boolean disableDepthTest) throws IOException {
        ImageRenderer.renderPictureWorldSpace(matrixStack, ImageDataParser.requestIdentifier(mediaEntry), pos, rotation, scale, pixelsPerBlock, light, overlay, tickDelta, disableDepthTest);
    }

    public static void renderPictureScreenSpace(class_332 context, class_2960 textureId, class_243 pos, class_243 rotation, Vector2d scale, float pixelsPerBlock, int light, int overlay, float tickDelta, boolean disableDepthTest) throws IOException {
        ImageDataParser.mergeImages();
        class_310 client = class_310.method_1551();
        float textureWidth = 16.0f;
        float textureHeight = 16.0f;
        class_3300 resourceManager = client.method_1478();
        try {
            class_1011 image;
            class_1044 texture = client.method_1531().method_4619(textureId);
            if (texture instanceof class_1043) {
                class_1043 nativeTexture = (class_1043)texture;
                image = nativeTexture.method_4525();
                textureWidth = (float)image.method_4307() / pixelsPerBlock;
                textureHeight = (float)image.method_4323() / pixelsPerBlock;
                image.close();
            }
            try {
                Optional<class_1011> imageOptional = client.method_1478().method_14486(textureId).map(resource -> {
                    class_1011 class_10112;
                    block8: {
                        InputStream inputStream = resource.method_14482();
                        try {
                            class_10112 = class_1011.method_4309((InputStream)inputStream);
                            if (inputStream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                        inputStream.close();
                    }
                    return class_10112;
                });
                if (imageOptional.isPresent()) {
                    image = imageOptional.get();
                    textureWidth = (float)image.method_4307() / pixelsPerBlock;
                    textureHeight = (float)image.method_4323() / pixelsPerBlock;
                    image.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Optional resourceOptional = resourceManager.method_14486(class_2960.method_60655((String)"lucidity", (String)"textures/lost-file.png"));
            class_1011 image = class_1011.method_4309((InputStream)((class_3298)resourceOptional.get()).method_14482());
            textureWidth = (float)image.method_4307() / pixelsPerBlock;
            textureHeight = (float)image.method_4323() / pixelsPerBlock;
            image.close();
        }
        float scaledWidth = (float)((double)textureWidth * scale.x);
        float scaledHeight = (float)((double)textureHeight * scale.y);
        int centerX = (int)(scaledWidth / 2.0f);
        int centerY = (int)(scaledHeight / 2.0f);
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.field_1724 == null) {
            return;
        }
        if (disableDepthTest) {
            GlStateManager._disableDepthTest();
        }
        GlStateManager._enableBlend();
        GlStateManager._depthMask((boolean)true);
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)pos.method_10216(), (float)pos.method_10214());
        Matrix3x2f matrix = context.method_51448().identity();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
        context.method_25290(GUI_TEXTURED_ALPHA, textureId, -centerX, -centerY, (float)centerX, (float)centerY, centerX, centerY, centerX, centerY);
        buffer.method_70815(matrix, (float)(-centerX), (float)(-centerY), 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_60803(light).method_22922(overlay);
        buffer.method_70815(matrix, (float)centerX, (float)(-centerY), 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_60803(light).method_22922(overlay);
        buffer.method_70815(matrix, (float)centerX, (float)centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_60803(light).method_22922(overlay);
        buffer.method_70815(matrix, (float)(-centerX), (float)centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_60803(light).method_22922(overlay);
        GlStateManager._disableCull();
        IMAGE.apply(textureId).method_60895(buffer.method_60800());
        GlStateManager._disableBlend();
        GlStateManager._enableDepthTest();
        GlStateManager._enableCull();
        context.method_51448().pushMatrix();
    }

    public static void renderPicture(class_4587 matrixStack, class_2960 textureId, class_243 pos, class_243 rotation, Vector2d scale, float pixelsPerBlock, int light, int overlay, float tickDelta, boolean disableDepthTest) throws IOException {
        ImageDataParser.mergeImages();
        class_310 client = class_310.method_1551();
        float textureWidth = 16.0f;
        float textureHeight = 16.0f;
        class_3300 resourceManager = client.method_1478();
        try {
            class_1011 image;
            class_1044 texture = client.method_1531().method_4619(textureId);
            if (texture instanceof class_1043) {
                class_1043 nativeTexture = (class_1043)texture;
                image = nativeTexture.method_4525();
                textureWidth = (float)image.method_4307() / pixelsPerBlock;
                textureHeight = (float)image.method_4323() / pixelsPerBlock;
                image.close();
            }
            try {
                Optional<class_1011> imageOptional = client.method_1478().method_14486(textureId).map(resource -> {
                    class_1011 class_10112;
                    block8: {
                        InputStream inputStream = resource.method_14482();
                        try {
                            class_10112 = class_1011.method_4309((InputStream)inputStream);
                            if (inputStream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                        inputStream.close();
                    }
                    return class_10112;
                });
                if (imageOptional.isPresent()) {
                    image = imageOptional.get();
                    textureWidth = (float)image.method_4307() / pixelsPerBlock;
                    textureHeight = (float)image.method_4323() / pixelsPerBlock;
                    image.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Optional resourceOptional = resourceManager.method_14486(class_2960.method_60655((String)"lucidity", (String)"textures/lost-file.png"));
            class_1011 image = class_1011.method_4309((InputStream)((class_3298)resourceOptional.get()).method_14482());
            textureWidth = (float)image.method_4307() / pixelsPerBlock;
            textureHeight = (float)image.method_4323() / pixelsPerBlock;
            image.close();
        }
        float scaledWidth = (float)((double)textureWidth * scale.x);
        float scaledHeight = (float)((double)textureHeight * scale.y);
        float centerX = scaledWidth / 2.0f;
        float centerY = scaledHeight / 2.0f;
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.field_1724 == null) {
            return;
        }
        if (disableDepthTest) {
            GlStateManager._disableDepthTest();
        }
        GlStateManager._enableBlend();
        GlStateManager._depthMask((boolean)true);
        matrixStack.method_22903();
        matrixStack.method_22904(pos.method_10216(), pos.method_10214(), pos.method_10215());
        matrixStack.method_22907((Quaternionfc)new Quaternionf().rotateX((float)Math.toRadians(rotation.field_1352)).rotateY((float)Math.toRadians(rotation.field_1351)).rotateZ((float)Math.toRadians(rotation.field_1350)));
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(matrix, -centerX, -centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_60803(light).method_22922(overlay);
        buffer.method_22918(matrix, centerX, -centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_60803(light).method_22922(overlay);
        buffer.method_22918(matrix, centerX, centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_60803(light).method_22922(overlay);
        buffer.method_22918(matrix, -centerX, centerY, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_60803(light).method_22922(overlay);
        GlStateManager._disableCull();
        IMAGE.apply(textureId).method_60895(buffer.method_60800());
        GlStateManager._disableBlend();
        GlStateManager._enableDepthTest();
        GlStateManager._enableCull();
        matrixStack.method_22909();
    }

    static {
        GUI_TEXTURED_ALPHA = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation("pipeline/gui_textured_alpha").withCull(false).build());
        IMAGE = class_156.method_34866(texture -> class_1921.method_24049((String)"image", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)GUI_TEXTURED_ALPHA, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false)).method_23617(false)));
    }
}

