/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.OreFinder;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.OreFinder.OreResolver;
import mypals.ml.features.selectiveRendering.SelectiveRenderingManager;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class MineralFinder {
    public static Map<class_2248, Color> MINERAL_BLOCKS = new HashMap<class_2248, Color>();
    public static final List<String> DEFAULT_SELECTED = Arrays.asList("minecraft:coal_ore;#000000", "minecraft:iron_ore;#D8D8D8", "minecraft:gold_ore;#FFD700", "minecraft:diamond_ore;#00FFFF", "minecraft:emerald_ore;#009900", "minecraft:redstone_ore;#FF0000", "minecraft:lapis_ore;#0000FF", "minecraft:copper_ore;#FFA500", "minecraft:nether_quartz_ore;#FFF0DC", "minecraft:nether_gold_ore;#FFA500", "minecraft:ancient_debris;#804020", "minecraft:obsidian;#200040", "minecraft:deepslate_coal_ore;#101010", "minecraft:deepslate_iron_ore;#BFBFBF", "minecraft:deepslate_gold_ore;#FFD700", "minecraft:deepslate_diamond_ore;#00CCCC", "minecraft:deepslate_emerald_ore;#009900", "minecraft:deepslate_redstone_ore;#990000", "minecraft:deepslate_lapis_ore;#000099", "minecraft:deepslate_copper_ore;#FFA500");

    public static void parseSelectedBlocks() {
        MINERAL_BLOCKS.clear();
        for (String entry : LucidityConfig.selectedBlocksToHighLight) {
            Optional block;
            String hexColor;
            Color color;
            String[] parts = entry.split(";");
            if (parts.length != 2) continue;
            Object blockId = parts[0].trim();
            if (!((String)blockId).contains(":")) {
                blockId = "minecraft:" + (String)blockId;
            }
            if ((color = MineralFinder.parseHexColor(hexColor = parts[1].trim())) == null || (block = class_7923.field_41175.method_17966(class_2960.method_60654((String)blockId))).isEmpty()) continue;
            MINERAL_BLOCKS.put((class_2248)block.get(), color);
        }
    }

    private static Color parseHexColor(String hex) {
        try {
            if (!hex.startsWith("#") || hex.length() != 7) {
                System.err.println("Bad HexColor: " + hex);
                return new Color(255, 255, 255);
            }
            int r = Integer.parseInt(hex.substring(1, 3), 16);
            int g = Integer.parseInt(hex.substring(3, 5), 16);
            int b = Integer.parseInt(hex.substring(5, 7), 16);
            return new Color(r, g, b);
        }
        catch (Exception e) {
            System.err.println("parse HexColor faild: " + hex);
            return new Color(255, 255, 255);
        }
    }

    public static boolean isMineral(class_2248 block) {
        return MINERAL_BLOCKS.containsKey(block);
    }

    public static boolean isExposedMineral(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        if (!MineralFinder.isMineral(block)) {
            return false;
        }
        for (class_2350 direction : class_2350.values()) {
            boolean isExposed;
            boolean bl = isExposed = world.method_8320(pos.method_10093(direction)).method_26204() != class_2246.field_10243 && !world.method_8320(pos.method_10093(direction)).method_26234((class_1922)world, pos.method_10093(direction));
            if (!isExposed && SelectiveRenderingManager.shouldRenderBlock(world.method_8320(pos.method_10093(direction)), pos.method_10093(direction))) continue;
            return true;
        }
        return false;
    }

    public static void iterateBlocksWithinDistance(class_2338 centerPos, double radius) {
        int r = (int)Math.ceil(radius);
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                class_2338 blockPos = new class_2338(centerPos.method_10263() + x, 0, centerPos.method_10260() + z);
                class_2791 chunk = class_310.method_1551().field_1687.method_22350(blockPos);
                for (int y = chunk.method_31607(); y <= chunk.method_31600(); ++y) {
                    blockPos = new class_2338(centerPos.method_10263() + x, centerPos.method_10264() + y, centerPos.method_10260() + z);
                    double distance = centerPos.method_10262((class_2382)blockPos);
                    if (!(distance <= radius * radius)) continue;
                    OreResolver.tryAddToRecordedOreListOrRemove(blockPos);
                }
            }
        }
    }
}

