/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.damageIndicator;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import mypals.ml.config.LucidityConfig;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.class_8103;
import net.minecraft.class_9274;
import org.jetbrains.annotations.Nullable;

public class DamageHandler {
    private static float lastHealth = 114514.0f;
    public static ArrayList<Indicator> indicaors = new ArrayList();

    public static void PlayerHealthMonitor() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        LucidityConfig.CONFIG_HANDLER.instance();
        float currentHealth = player.method_6032();
        boolean damaged = lastHealth != 114514.0f && currentHealth < lastHealth;
        lastHealth = currentHealth;
        if (damaged) {
            class_1282 damageSource = player.method_6081();
            if (damageSource == null || client.field_1687 == null) {
                return;
            }
            class_243 pos = damageSource.method_5510() != null ? damageSource.method_5510() : player.method_19538();
            boolean isSourceMovable = damageSource.method_5526() != null;
            Indicator i = new Indicator(pos, damageSource, isSourceMovable, client.field_1687.method_8510() + (long)LucidityConfig.damageIndicatorLifeTime);
            indicaors.add(i);
        }
        DamageHandler.updateIndicators();
    }

    public static void updateIndicators() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        long currentTime = client.field_1687.method_8510();
        for (int i = indicaors.size() - 1; i >= 0; --i) {
            Indicator indicaor = indicaors.get(i);
            if (indicaor.lifeTime < currentTime) {
                indicaors.remove(i);
            }
            if (!indicaor.isSourceMovable) continue;
            if (indicaor.source.method_5526() == null) {
                return;
            }
            indicaor.pos = indicaor.source.method_5526().method_19538();
        }
    }

    public static float calculateTargetDamage(class_1282 source, float amount, class_1309 target) {
        if (!target.method_64421(source)) {
            if (!source.method_48789(class_8103.field_42241)) {
                amount = class_1280.method_5496((class_1309)target, (float)amount, (class_1282)source, (float)target.method_6096(), (float)((float)target.method_45325(class_5134.field_23721)));
            }
            amount = DamageHandler.modifyAppliedDamage(source, amount, target);
            return Math.max(amount - target.method_6067(), 0.0f);
        }
        return 0.0f;
    }

    private static float modifyAppliedDamage(class_1282 source, float amount, class_1309 target) {
        if (source.method_48789(class_8103.field_42243)) {
            return amount;
        }
        if (target.method_6059(class_1294.field_5907) && !source.method_48789(class_8103.field_42244)) {
            int i = (target.method_6112(class_1294.field_5907).method_5578() + 1) * 5;
            int j = 25 - i;
            float f = amount * (float)j;
            amount = Math.max(f / 25.0f, 0.0f);
        }
        return amount;
    }

    public static float calculatePlayerDamage(class_1657 player, class_1297 target) {
        float baseDamage = player.method_6123() ? player.field_51569 : (float)player.method_45325(class_5134.field_23721);
        class_1799 weapon = player.method_59958();
        float additionalDamage = 0.0f;
        float weaponDamage = (float)DamageHandler.getWeaponAttackDamage(weapon);
        baseDamage += weaponDamage;
        float cooldownProgress = player.method_7261(0.5f);
        baseDamage *= 0.2f + cooldownProgress * cooldownProgress * 0.8f;
        additionalDamage *= cooldownProgress;
        if (player.method_5624() && cooldownProgress > 0.9f) {
            baseDamage *= 1.5f;
        }
        float finalDamage = baseDamage + additionalDamage;
        return finalDamage;
    }

    public static double getWeaponAttackDamage(class_1799 itemStack) {
        AtomicReference<Double> v = new AtomicReference<Double>(0.0);
        for (class_9274 attributeModifierSlot : class_9274.values()) {
            itemStack.method_60617(attributeModifierSlot, (attribute, modifier, display) -> {
                if (class_5134.field_23721.equals(attribute)) {
                    v.set(modifier.comp_2449());
                }
            });
        }
        return v.get();
    }

    public static class Indicator {
        @Nullable
        public class_243 pos;
        public boolean isSourceMovable;
        @Nullable
        public class_1282 source;
        public long lifeTime;

        public Indicator(@Nullable class_243 pos, @Nullable class_1282 source, boolean isSourceMovable, long lifeTime) {
            this.pos = pos;
            this.source = source;
            this.isSourceMovable = isSourceMovable;
            this.lifeTime = lifeTime;
        }
    }
}

