/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.damageIndicator;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.awt.Color;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.damageIndicator.DamageHandler;
import net.minecraft.class_10799;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import org.joml.Vector2d;

public class IndicatorRenderer {
    public static class_2960 indicatorTexture = class_2960.method_60655((String)"lucidity", (String)"textures/gui/indicator/damage_indicator.png");

    public static void renderIndicators(class_332 context) {
        class_310 client = class_310.method_1551();
        if (!client.field_1690.field_1842 && client.field_1690.method_31044().method_31034()) {
            LucidityConfig.CONFIG_HANDLER.instance();
            float r = (float)LucidityConfig.indicatorColor.getRed() / 255.0f;
            float g = (float)LucidityConfig.indicatorColor.getGreen() / 255.0f;
            float b = (float)LucidityConfig.indicatorColor.getBlue() / 255.0f;
            if (LucidityConfig.enableDamageIndicator) {
                IndicatorRenderer.renderIndicators(client, context, r, g, b);
            }
            if (LucidityConfig.damageCaculator) {
                IndicatorRenderer.renderDamage(client, context, r, g, b);
            }
        }
    }

    private static void renderDamage(class_310 client, class_332 context, float r, float g, float b) {
        class_1282 damageSource = client.field_1724.method_48923().method_48802((class_1657)client.field_1724);
        float playerDellDamage = 0.0f;
        float realDamage = 0.0f;
        if (class_310.method_1551().field_1765.method_17783() == class_239.class_240.field_1331) {
            class_1309 playerLookingAtEntity;
            class_3966 entityHitResult = (class_3966)class_310.method_1551().field_1765;
            if (entityHitResult.method_17782() instanceof class_1309 && (playerLookingAtEntity = (class_1309)entityHitResult.method_17782()) != null) {
                playerDellDamage = DamageHandler.calculatePlayerDamage((class_1657)client.field_1724, (class_1297)playerLookingAtEntity);
                realDamage = DamageHandler.calculateTargetDamage(damageSource, playerDellDamage, playerLookingAtEntity);
            }
        } else {
            playerDellDamage = DamageHandler.calculatePlayerDamage((class_1657)client.field_1724, null);
        }
        int x = class_310.method_1551().method_22683().method_4486() - 110;
        int y = class_310.method_1551().method_22683().method_4502() / 2;
        if (realDamage != 0.0f) {
            context.method_51433(class_310.method_1551().field_1772, class_2561.method_43471((String)"info.lucidity.clientsideDamageCalculation.damageToEnemy").getString() + realDamage, x, y, new Color(r, g, b, 255.0f).getRGB(), true);
        }
        if (playerDellDamage != 0.0f) {
            context.method_51433(class_310.method_1551().field_1772, class_2561.method_43471((String)"info.lucidity.clientsideDamageCalculation.damageDealing").getString() + playerDellDamage, x, y + 10, 0xFFFFFF, true);
        }
    }

    private static void renderIndicators(class_310 client, class_332 context, float r, float g, float b) {
        DamageHandler.indicaors.forEach(indicator -> {
            if (client.field_1724 != null) {
                class_243 playerPos = client.field_1724.method_19538();
                class_243 damagePos = indicator.isSourceMovable && indicator.source != null && indicator.source.method_5529().method_19538() != null ? indicator.source.method_5529().method_19538() : indicator.pos;
                double finalAngle = IndicatorRenderer.calculateFinalAngle(client.field_1724.method_5828(1.0f), playerPos, damagePos);
                float radians = (float)Math.toRadians(finalAngle);
                float radians2 = (float)Math.toRadians(finalAngle - 90.0);
                int textureWidth = 100;
                int distanceFromCenter = LucidityConfig.indicatorOffset;
                int x = client.method_22683().method_4486() / 2;
                int y = client.method_22683().method_4502() / 2;
                float indicatorX = (float)x + (float)((double)distanceFromCenter * Math.cos(radians2));
                float indicatorY = (float)y + (float)((double)distanceFromCenter * Math.sin(radians2));
                float a = IndicatorRenderer.calculateAlpha(client.field_1687.method_8510(), indicator.lifeTime, LucidityConfig.damageIndicatorLifeTime) / 255.0f;
                context.method_51448().pushMatrix();
                context.method_51448().translate(indicatorX, indicatorY);
                context.method_51448().rotate((float)finalAngle);
                context.method_51448().translate(-indicatorX, -indicatorY);
                GlStateManager._enableBlend();
                context.method_25291(class_10799.field_56883, indicatorTexture, (int)(indicatorX - (float)(textureWidth / 2)), (int)(indicatorY - (float)(textureWidth / 2)), 0.0f, 0.0f, textureWidth, textureWidth, textureWidth, textureWidth, new Color(r, g, b, a).getRGB());
                GlStateManager._disableBlend();
                context.method_51448().popMatrix();
            }
        });
    }

    private static double calculateFinalAngle(class_243 playerForward, class_243 playerPosition, class_243 damagePosition) {
        double playerAngle = Math.atan2(playerForward.field_1352, playerForward.field_1350) * 180.0 / Math.PI;
        Vector2d enemyVec = new Vector2d(damagePosition.field_1352 - playerPosition.field_1352, damagePosition.field_1350 - playerPosition.field_1350);
        double enemyAngle = Math.atan2(enemyVec.x, enemyVec.y) * 180.0 / Math.PI;
        double finalAngle = enemyAngle - playerAngle;
        return -finalAngle;
    }

    public static float calculateAlpha(long currentTime, long lifeTime, long maxLifetime) {
        long remainingTime = lifeTime - currentTime;
        remainingTime = Math.max(0L, remainingTime);
        float alpha = (float)remainingTime / (float)maxLifetime;
        int alphaValue = (int)(alpha * (float)LucidityConfig.indicatorColor.getAlpha());
        return alphaValue;
    }
}

